<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTablesalaryadv", '
    function filterDataTablesalaryadv(status)
    {
        var table_id = "#tbl_employeesalaryadvance_details_applied";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        var table = $(table_id).DataTable({
            pageLength: 50,
            processing: true,
            ordering: false,
             searching: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salarychecker/GetAdvanceDetailsChecker') . '",
                type: "POST",
                data: {"status": status,"frmdate":frmdate,"todate":todate},
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight(),
            },
            autoWidth: false,
            "columnDefs": [
                    {
                        "targets": [5],  // Right-align these columns
                        "className":"dt-right"
                    }
                ]
        });
        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
       var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        filterDataTablesalaryadv("",frmdate,todate);
    });
', CClientScript::POS_HEAD);
$cs->registerScript("advancedetails", "function advancedetails(status){  
  $('#tbl_employeesalaryadvance_details_applied').DataTable().destroy();
     var frmdate = $('#from_date').val();  // Re-get the date values when changing status
      var todate = $('#to_date').val();
      filterDataTablesalaryadv(status, frmdate, todate);
 
};", CClientScript::POS_HEAD);
?>
<br/>


<div class="row">
    <div class="col-md-12">
        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="ch_salary_advance">
                    <h4 class="panel-title">
                        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseThree" aria-expanded="true" aria-controls="collapseThree">
                           SALARY ADVANCE
                        </a>
                    </h4>
                </div>
                <div id="collapseThree" class="panel-collapse collapse" role="tabpanel" aria-labelledby="ch_salary_advance">
                    <div class="panel-body">
                        <div id="chartdivsaladv"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-sm-12">
    <div id="content_tables" class="content_table10">
    <table class="table table-hover table-bordered personal-task" id="tbl_employeesalaryadvance_details_applied" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Branch</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Apply Date</th>  
                            <th>Payment Date</th>  
                            <th>Amount</th>
                            <th>Status</th> 
                        </tr>
                        </thead>
                    </table>
        </table>
    </div>
</div>
   


  <?php
$salary_branch_id;
$model_advance_payment = new EmployeeSalaryAdvance();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));

$applied_condition = "advance_payment_status= '1' AND apply_date  >= '" . $from_date. "' AND  apply_date  <= '" .$to_date. "'";
$count_applied = $model_advance_payment->with('employeedetail')->count(array('condition' => $applied_condition));
$level1_condition = "advance_payment_status= '2' AND apply_date  >= '" . $from_date. "' AND  apply_date  <= '" .$to_date. "' ";
$count_level1 = $model_advance_payment->with('employeedetail')->count(array('condition' => $level1_condition));
$level2_condition = "advance_payment_status= '4' AND apply_date  >= '" . $from_date. "' AND  apply_date  <= '" .$to_date. "' ";
$count_level2 = $model_advance_payment->with('employeedetail')->count(array('condition' => $level2_condition));
$level3_condition = "advance_payment_status= '6' AND apply_date  >= '" . $from_date. "' AND  apply_date  <= '" .$to_date. "'";
$count_level3 = $model_advance_payment->with('employeedetail')->count(array('condition' => $level3_condition));
$level4_condition = "advance_payment_status= '8' AND apply_date  >= '" . $from_date. "' AND  apply_date  <= '" .$to_date. "'";
$approved_condition = "advance_payment_status= '12' AND apply_date  >= '" . $from_date. "' AND  apply_date  <= '" .$to_date. "'";
$count_approved = $model_advance_payment->with('employeedetail')->count(array('condition' => $approved_condition));


$hasData = $count_applied > 0 || $count_level1 > 0 || $count_level2 > 0 || $count_level3 > 0 || $count_approved > 0;
?>
<!-- Chart code -->
<?php if ($hasData): ?>
<script>

am4core.ready(function() {

    am4core.addLicense("ch-custom-attribution");

// Themes begin
am4core.useTheme(am4themes_animated);
// Themes end

// Create chart instance
var chart = am4core.create("chartdivsaladv", am4charts.PieChart);

// Add data
chart.data = [ {
  "advancepaymentstatus": "Applied",
  "litres":  <?php echo $count_applied;?>
}, {
  "advancepaymentstatus": "Level 1",
  "litres": <?php echo $count_level1;?>
}, {
  "advancepaymentstatus": "Level 2",
  "litres": <?php echo $count_level2;?>
}, {
  "advancepaymentstatus": "Level 3",
  "litres": <?php echo $count_level3;?>
},  {
  "advancepaymentstatus": "Approved",
  "litres": <?php echo $count_approved;?>
} ];

// Set inner radius
chart.innerRadius = am4core.percent(50);
chart.legend = new am4charts.Legend();
// Set inner radius
chart.innerRadius = am4core.percent(50);

// Add and configure Series
var pieSeries = chart.series.push(new am4charts.PieSeries());
pieSeries.dataFields.value = "litres";
pieSeries.dataFields.category = "advancepaymentstatus";
pieSeries.slices.template.stroke = am4core.color("#fff");
pieSeries.slices.template.strokeWidth = 2;
pieSeries.slices.template.strokeOpacity = 1;





pieSeries.slices.template.events.on("hit", function(ev){
  var labelname1 = (ev.target.dataItem.category);
  //alert(labelname1);
  if(labelname1 == 'Applied'){
    advancedetails(1);
  
}

  else if(labelname1 == 'Level 1'){
  
    advancedetails(2);
  }

  else if(labelname1 == 'Level 2'){
  
    advancedetails(4);
  }
  else if(labelname1 == 'Level 3'){
  
    advancedetails(6);
  }
  else if(labelname1 == 'Approved'){
  
    advancedetails(12);
  }

});

// This creates initial animation
pieSeries.hiddenState.properties.opacity = 1;
pieSeries.hiddenState.properties.endAngle = -90;
pieSeries.hiddenState.properties.startAngle = -90;

}); // end am4core.ready()
</script>

<?php endif; ?>



<style>
#chartdivsaladv {
  width: 90%;
  height: 400px;
}

</style>