<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTablepensionchk", '
    var table;  // Declare a variable to hold the DataTable instance

    function filterDataTablepensionchk(expstatus)
    {
        var table_id = "#tbl_pension_details";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();

        if (!$.fn.dataTable.isDataTable(table_id)) {
            // Initialize DataTable only if it has not been initialized yet
            table = $(table_id).DataTable({
                pageLength: 50,
                processing: true,
                ordering: false,
                searching: false,
                ajax: {
                    url: "' . Yii::app()->createUrl('hr/salarychecker/PensionChecker') . '",
                    type: "POST",
                    data: {"branch_id": branch_id, "frmdate": frmdate, "todate": todate},
                    cache: false,
                },
                serverSide: true,
                fixedColumns: true,
                fixedHeader: {
                    headerOffset: $("header.main").outerHeight(),
                },
                autoWidth: false,
                "columnDefs": [
                    {
                        "targets": [7],  // Right-align these columns
                        "className":"dt-right"
                    }
                ],
                // Apply the createdRow callback to check pension status and apply row color
                "createdRow": function(row, data, dataIndex) {
                   
                    if (data[5] == "No") {  
                     $(row).addClass("bg-danger");  // Add the Bootstrap class bg-danger for red background
                    }
                }
            });
        } else {
            // If DataTable is already initialized, just reload the data
            table.ajax.reload();
        }

        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
        filterDataTablepensionchk("");  // Initialize the table on page load
    });
', CClientScript::POS_HEAD);
?>
<div class="col-sm-2"></div>
<div class="col-sm-8" style="margin-top:10px">
    <?php
    $model_pension = MasPension::model()->findAll(array('condition' => "t.isActive='Y'"));
    ?>
    <table class="table table-hover table-bordered personal-task">
        <thead>
            <tr>
                <th>Scheme Name</th>
                <th>Salary Types</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($model_pension as $pension): ?>
                <tr>
                    <td><?= $pension->scheme_name; ?></td>
                    <?php
                    if(!empty($pension->salary_type)){
                        $salarytype= explode(",", $pension->salary_type); 
                        $array_componets =array();
                        foreach ($salarytype as $eachValue){
                           $mas_salarytype = MasSalarytype::model()->findByPk($eachValue);
                           $array_componets[] =$mas_salarytype->salary_name;
                        }
                    } ?>
                    <td><?php echo implode(' , ', $array_componets); ?></td>
                </tr>
            <?php
                endforeach;
            ?>
        </tbody>
    </table>
</div>
<div class="col-sm-12">
    <span style="font-weight: bold;">Note :- </span><span style="color: red; font-style: italic; font-weight: bold;"> ** Below data not based on filtered date</span>
    <br>
    <br>
    <div id="content_tables" class="content_table10">
    
     <table class="table table-hover table-bordered personal-task" id="tbl_pension_details" style="font-size:13px;">
                    <thead>
                        <tr>
                           <th>No</th>
                            <th>Branch</th>
                            <th>Employee Code</th>  
                            <th>Employee Name</th>
                            <th>Nationality</th>
                            <th>Joining Date</th>
                            <th>Pension</th>
                            <th>Percentage( % )</th>
                            
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
<!-- </div> -->

<style>
.dt-right{text-align: right;}
</style>