<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTablenetsalchk", '
    var table;  // Declare a variable to hold the DataTable instance
    function filterDataTablenetsalchk()
    {
        var table_id = "#tbl_net_salary_details";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();

        if (!$.fn.dataTable.isDataTable(table_id)) {
            // Initialize DataTable only if it has not been initialized yet
            table = $(table_id).DataTable({
                pageLength: 50,
                processing: true,
                ordering: false,
                searching: false,
                ajax: {
                    url: "' . Yii::app()->createUrl('hr/salarychecker/NetSalaryChecker') . '",
                    type: "POST",
                    data: {"branch_id": branch_id, "frmdate": frmdate, "todate": todate},
                    cache: false,
                },
                serverSide: true,
                fixedColumns: true,
                fixedHeader: {
                    headerOffset: $("header.main").outerHeight(),
                },
                autoWidth: false,
                "rowCallback": function ( row, data ){ 
                    if (data[7]==1){
                        $("td", row).css("background-color", "#F7C4C3");
                    }else{
                        $("td", row).css("background-color", "#D6FCDA");
                    }
                },
                "columnDefs": [
                    {
                        "targets": [4,5,6],  // Right-align these columns
                        "className":"text-right"
                    },
                    {
                        "targets": [7],"visible": false,
                    },
                ]
            });
        } else {
            // If DataTable is already initialized, just reload the data
            table.ajax.reload();
        }

        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
       filterDataTablenetsalchk();  // Initialize the table on page load
    });
', CClientScript::POS_HEAD);
 $model_settings = HrGenerelSettings::model()->find();
?>
<div class="col-sm-12">
    <div class="color-indicator pull-right">
        <span class="verti"> Variance</span>
        <span style="display: inline-block;width:30px;height:30px;background:#D6FCDA; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Above <?php echo $model_settings->salary_percentage; ?> %</span>
        <span style="display: inline-block;width:30px;height:30px;background:#F7C4C3; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Below than <?php echo $model_settings->salary_percentage; ?> %</span>
    </div>
    <div id="content_tables" class="content_table10">
        <table class="table table-hover table-bordered personal-task" id="tbl_net_salary_details" style="font-size:13px;">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Branch</th>
                    <th>Employee Code</th>  
                    <th>Employee Name</th>
                    <th>Gross Salary</th>
                    <th>Net Salary</th>
                    <th>Difference</th>
                    <th>Difference</th>
                </tr>
            </thead>
        </table>
    </div>
</div>