<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTableexpense", '
    function filterDataTableexpense(expstatus)
    {
        var table_id = "#tbl_employee_expense_details";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        var table = $(table_id).DataTable({
            pageLength: 50,
            processing: true,
            ordering: false,
             searching: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salarychecker/GetExpenseList') . '",
                type: "POST",
                data: {"expstatus": expstatus, "branch_id": branch_id,"frmdate":frmdate,"todate":todate},
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight(),
            },
            autoWidth: false,
            "columnDefs": [
                    {
                        "targets": [6],  // Right-align these columns
                        "className":"dt-right"
                    }
                ]
        });
        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
       var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        filterDataTableexpense("",frmdate,todate);
    });
', CClientScript::POS_HEAD);


$cs->registerScript("expensedetails", "function expensedetails(expstatus){  
    $('#tbl_employee_expense_details').DataTable().destroy();
    
    filterDataTableexpense(expstatus);
   
};", CClientScript::POS_HEAD);
?>
<div class="row">
    <div class="col-md-12">
        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="ch_expense">
                    <h4 class="panel-title">
                        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseThree" aria-expanded="true" aria-controls="collapseThree">
                            EXPENSE
                        </a>
                    </h4>
                </div>
                <div id="collapseThree" class="panel-collapse collapse" role="tabpanel" aria-labelledby="ch_expense">
                    <div class="panel-body">
                        <div id="chartdiv3"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-sm-12">
    <div id="content_tables" class="content_table10">
        <table class="table table-hover table-bordered personal-task" id="tbl_employee_expense_details" style="font-size:13px;">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Branch</th>
                    <th>Employee Code</th>  
                    <th>Employee Name</th>  
                    <th>Apply Date</th>
                    <th>Approved Date</th>
                    <th>Total Amount</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
        </table>
    </div>
</div>
<!-- </div> -->

<?php
$model_expense_details = new EmployeeExpense();
$to_date = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
$from_date = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
if ($salary_branch_id) {
    $expense_applied_condition = "status= '1' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND created_date <= '" . $to_date . "'";
} else {
    $expense_applied_condition = "status= '1' AND created_date <= '" . $to_date . "'";
}


if ($salary_branch_id) {
    $expense_level1_condition = "status= '2' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND created_date<= '" . $to_date . "'";
} else {
    $expense_level1_condition = "status= '2' AND created_date<= '" . $to_date . "'";
}

if ($salary_branch_id) {
    $expense_level2_condition = "status= '4' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND created_date<= '" . $to_date . "'";
} else {
    $expense_level2_condition = "status= '4' AND created_date<= '" . $to_date . "'";
}

if ($salary_branch_id) {
    $expense_level3_condition = "status= '6' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND created_date<= '" . $to_date . "'";
} else {
    $expense_level3_condition = "status= '6' AND created_date<= '" . $to_date . "'";
}

if ($salary_branch_id) {
    $expense_approved_condition = "status= '12' AND employeedetail.branch_or_sponsor_id='" . $salary_branch_id . "' AND created_date<= '" . $to_date . "'";
} else {
    $expense_approved_condition = "status= '12'  AND created_date<= '" . $to_date . "'";
}


$expense_count_applied = $model_expense_details->with('employeedetail')->count(array('condition' => $expense_applied_condition));
$expense_count_level1 = $model_expense_details->with('employeedetail')->count(array('condition' => $expense_level1_condition));
$expense_count_level2 = $model_expense_details->with('employeedetail')->count(array('condition' => $expense_level2_condition));
$expense_count_level3 = $model_expense_details->with('employeedetail')->count(array('condition' => $expense_level3_condition));
$expense_count_approved = $model_expense_details->with('employeedetail')->count(array('condition' => $expense_approved_condition));
$hasData = $expense_count_applied > 0 || $expense_count_level1 > 0 || $expense_count_level2 > 0 || $expense_count_level3 > 0 || $expense_count_approved > 0;
?>
<!-- Chart code -->
<?php if ($hasData): ?>
    <script>

        am4core.ready(function () {



            am4core.addLicense("ch-custom-attribution");

            // Themes begin
            am4core.useTheme(am4themes_animated);
            // Themes end

            // Create chart instance
            var chart = am4core.create("chartdiv3", am4charts.PieChart);

            // Add data
            chart.data = [{
                    "employeeexpensedata": "Applied",
                    "litres": <?php echo $expense_count_applied; ?>
                }, {
                    "employeeexpensedata": "Level 1",
                    "litres": <?php echo $expense_count_level1; ?>
                }, {
                    "employeeexpensedata": "Level 2",
                    "litres": <?php echo $expense_count_level2; ?>
                }, {
                    "employeeexpensedata": "Level 3",
                    "litres": <?php echo $expense_count_level3; ?>
                }, {
                    "employeeexpensedata": "Approved",
                    "litres": <?php echo $expense_count_approved; ?>
                }];

            // Set inner radius
            chart.innerRadius = am4core.percent(50);
            chart.legend = new am4charts.Legend();
            // Set inner radius
            chart.innerRadius = am4core.percent(50);

            // Add and configure Series
            var pieSeries = chart.series.push(new am4charts.PieSeries());
            pieSeries.dataFields.value = "litres";
            pieSeries.dataFields.category = "employeeexpensedata";
            pieSeries.slices.template.stroke = am4core.color("#fff");
            pieSeries.slices.template.strokeWidth = 2;
            pieSeries.slices.template.strokeOpacity = 1;
            pieSeries.slices.template.events.on("hit", function (ev) {
                var labelname2 = (ev.target.dataItem.category);
                //alert(labelname2);
                if (labelname2 == 'Applied') {
                    expensedetails(1);

                } else if (labelname2 == 'Level 1') {

                    expensedetails(2);
                } else if (labelname2 == 'Level 2') {

                    expensedetails(4);
                } else if (labelname2 == 'Level 3') {

                    expensedetails(6);
                } else if (labelname2 == 'Level 4') {

                    expensedetails(8);
                } else if (labelname2 == 'Level 5') {

                    expensedetails(10);
                } else if (labelname2 == 'Approved') {

                    expensedetails(12);
                }

            });

            // This creates initial animation
            pieSeries.hiddenState.properties.opacity = 1;
            pieSeries.hiddenState.properties.endAngle = -90;
            pieSeries.hiddenState.properties.startAngle = -90;

        }); //am4core.ready()
    </script>
<?php endif; ?>
<style>
    #chartdiv3 {
        width: 90%;
        height: 400px;
    }
</style>