<?php
$startDate = date('01/m/Y');
$endDate = date('t/m/Y');
?>
<!-- script added by abin on 11-09-2023 to impliment amchart 4 -->
<script src="https://cdn.amcharts.com/lib/4/core.js"></script>
<script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
<script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
<!-- end -->
<style>
    #employeesalarycheckerindexdropdown .material-select-label {
        display: none;
    }
</style>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">Salary Checker
        <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeesalarycheckerindexdropdown">
                <?php echo CHtml::HiddenField('salary_branch_id'); ?>
                <?php echo CHtml::HiddenField('from_date', $startDate); ?>
                <?php echo CHtml::HiddenField('to_date', $endDate); ?>
                <span class="col-sm-1 pull-right" style=" position: relative;top: 3px;">
                    <a href="javascript:void(0);" onclick="loadchecker();" class="btn btn-warning"><i class="fa fa-refresh"></i> </a>   
                </span>
                <span class="col-sm-3 pull-right"> 
                    <?php echo CHtml::dropdownlist('sal_year_id', date('Y'), HrGenerelSettings::listYears(4, 0), array('data-search' => true, 'empty' => 'Year', 'title' => 'Please Select Year', 'onchange' => 'setDateRange();')); ?>                                                   
                </span>
                <span class="col-sm-3 pull-right"> 
                    <?php echo CHtml::dropdownlist('sal_month_id',date('m'), HrGenerelSettings::listMonths(), array('data-search' => true, 'empty' => 'Month', 'title' => 'Please Select Month', 'onchange' => 'setDateRange();')); ?>                                                   
                </span>
                <?php //echo CHtml::dropdownlist('salary_branch_id', '', MasCompanyBranchSponsor::getSalaryBranches(), array('empty' => 'All Branches', 'class' => 'col-sm-3 form-control_1', 'title' => 'Please Select Branch', 'style' => 'width:150px;', 'onchange' => 'GetBranchDetails();')); ?>                                                   
                <?php //echo CHtml::textField('from_date', $startDate, array('class' => 'datepicker', 'data-label' => 'From Date')); ?>                                                   
                <?php //echo CHtml::textField('to_date', $endDate, array('class' => 'datepicker', 'data-label' => 'To Date')); ?>  
                
            </div>
            
        </div>
    </header>
    <div id="div_checker_contents"></div>
</section>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datefield", "$(document).ready(function() {
    materializing('.material');
//    loadchecker();
});", CClientScript::POS_HEAD);
$cs->registerScript("loadchecker", "function loadchecker() {
    var salary_branch_id = $('#salary_branch_id').val();
    var from_date = $('#from_date').val();
    var to_date = $('#to_date').val();

    // Proceed with AJAX request without checking if the branch is empty
    jQuery.ajax({
        'data' : {
            'salary_branch_id': salary_branch_id,  // Can be empty or null
            'from_date': from_date,
            'to_date': to_date
        },
        'type': 'post',
        'url': '" . Yii::app()->createUrl('hr/salarychecker/LoadCheckerTabContent') . "',
        'cache': false,
        'success': function(data) {
            $('#div_checker_contents').html(data);
        },
        'beforeSend': function() {
            $('#loader').show();
        },
        'complete': function() {
            $('#loader').hide();
        }
    });
};", CClientScript::POS_HEAD);
?>

<script>
function setDateRange() {
    // Get the selected year and month
    const year = document.getElementById('sal_year_id').value;
    const month = document.getElementById('sal_month_id').value;

    if (year && month) {
        // Get the first day of the selected month
        const startDate = new Date(year, month - 1, 1);
        
        // Get the last day of the selected month
        const endDate = new Date(year, month, 0);
        
        // Format the dates as 'DD/MM/YYYY'
        const formatDate = (date) => {
            const dd = String(date.getDate()).padStart(2, '0');
            const mm = String(date.getMonth() + 1).padStart(2, '0');
            const yyyy = date.getFullYear();
            return `${dd}/${mm}/${yyyy}`;
        };

        // Set the values of the hidden fields
        document.getElementById('from_date').value = formatDate(startDate);
        document.getElementById('to_date').value = formatDate(endDate);
    }
}
</script>
