

<?php
//for list entity with count
$employeeModel = new Employee();
$employees = Employee::model()->findAll(array(
    'condition' => 't.isActive = "Y"',  
   'with' => array('branch_sponsor'),  
    'order' => 'branch_sponsor.hr_code ASC', 
    
));
$totalEmployeeCount = 0;
$finalData = [];
foreach ($employees as $employee) {
    $masBranch = $employee->branch_sponsor; 
    if ($masBranch) {
        $branch_id =  $masBranch->id; 
        $branch_name =  $masBranch->branch_or_sponsor_name;
        if (!isset($finalData[ $branch_id])) {
            $finalData[ $branch_id] = [
                'branch_name' => $branch_name, 
                'employee_count' => 0, 
                'employees' => []
            ];
        }
        $finalData[$branch_id]['employee_count']++;
        $finalData[$branch_id]['employees'][] = $employee;
        $totalEmployeeCount++;
    }
}

?>

<span style="font-weight: bold;">Note :- </span><span style="color: red; font-style: italic; font-weight: bold;">** Below data not based on filtered date</span>
<br>
<br>
<!-- <div class="row"> -->
<div class="col-sm-2"></div>
<div class="col-sm-8" style="margin-top:10px">
<table class="table table-hover table-bordered personal-task">
<thead>
<tr>
<th>Branch Name</th>
<th>Employee Count</th>
</tr>
</thead>

<?php
foreach ($finalData as $branchData) {
?>
<tr>
<td><?= $branchData['branch_name']?></td>
<td style="text-align:right;"><?= $branchData['employee_count']?></td>
</tr>
<?php
}
?>

<tr style="font-weight: bold;">
                <td>Total </td>
                <td style="text-align:right;"><?= $totalEmployeeCount ?></td>
            </tr>

</table>
</div>
<div class="col-sm-2"></div>



<style>
.dt-right{text-align: right;}
</style>