<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("filterDataTableflexttime", '
    function filterDataTableflexttime(status)
    {
        var table_id = "#tbl_absent_attendance_request";
        var branch_id = "' . $salary_branch_id . '"; // Ensure proper PHP variable embedding here
        var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
        var table = $(table_id).DataTable({
            pageLength: 50,
            processing: true,
            ordering: false,
             searching: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/salarychecker/AttendanceAbsentChecker') . '",
                type: "POST",
                data: {"status": status,"frmdate":frmdate,"todate":todate},
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight(),
            },
            autoWidth: false,
            "columnDefs": [
                    {
                        
                    }
                ]
        });
        $(".dataTables_scrollFoot").hide();
    }

    $(document).ready(function() {
       var frmdate=$("#from_date").val();
        var todate=$("#to_date").val();
       filterDataTableflexttime("",frmdate,todate);
    });
', CClientScript::POS_HEAD);

?>
<br/>
<?php  if (Yii::app()->user->authorised_user == 1) { ?>
<?php 
$sql = "
    SELECT employee_id, attendance_date, COUNT(*) AS entry_count
    FROM erp_hr_employee_attendance
    GROUP BY employee_id, attendance_date
    HAVING COUNT(*) > 1
    ORDER BY attendance_date ASC
";
$model_total = Yii::app()->db->createCommand($sql)->queryAll();
?>
<div class="col-sm-2"></div>
<div class="col-sm-8">
    <?php
    ?>
    <table class="table table-hover table-bordered personal-task">
        <thead>
            <tr>
                <th>No</th>
                <th>Employee Code</th>
                <th>Employee Name</th>
                <th>Date</th>
                <th>Count</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 1;
            foreach ($model_total as $attendance):
                $model_employee = Employee::model()->findByPk($attendance['employee_id']);
                ?>
                <tr>
                    <td><?php echo $i; ?></td>
                    <td><?php echo $model_employee->employeecode; ?></td>
                    <td><?php echo $model_employee->employeefullname; ?></td>
                    <td><?php echo date('d/m/Y', strtotime($attendance['attendance_date'])); ?></td>
                    <td><?php echo $attendance['entry_count']; ?></td>
                </tr>
                <?php
            endforeach;
            ?>
        </tbody>
    </table>
</div>
<?php } ?>
<div class="col-sm-12">
    <div id="content_tables" class="content_table10">
        <table class="table table-hover table-bordered personal-task" id="tbl_absent_attendance_request" style="font-size:13px;">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Branch</th>
                    <th>Employee Code</th>
                    <th>Employee Name</th>
                    <th>Absent Date</th>  
                </tr>
            </thead>
        </table>
    </div>
</div>
   


  