<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'salary_advance-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">   			
                <?php
                if($model->id>0){
                    echo CHtml::textField('employee_name',$model->employeedetail->employeefullname,array('class'=>'tooltipster','title'=>'Employee Name <span style="color:red">*</span>','data-label'=>'Employee Name','readonly'=>true));
                    echo $form->hiddenField($model, 'employee_id');
                }else{
                    echo $form->dropDownList($model,'employee_id', Employee::getemployee($branch), array('empty' => 'Select', 'data-label' => 'Employee Name <span style="color:red">*</span>','data-search'=>'true','onchange'=>'getsalary(this.value);'));
                }
                ?>			
                <?php //echo Chtml::hiddenField('employee_salary',$salary); ?>
            </li>
            <li class="col-sm-6">      
                <?php echo Chtml::textField('employee_salary',$salary,array('class'=>'tooltipster','title'=>' Salary','data-label'=>' Salary <span style="color:red">*</span>','readonly'=>true)); ?>    
            </li>
            <li class="col-sm-4"> 
                <?php echo $form->hiddenField($model, 'function_type'); ?>
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'amount',array('class'=>'tooltipster','title'=>' Amount','data-label'=>' Amount <span style="color:red">*</span>','onkeypress' => 'return isNumberKey(event)','onkeyup'=>'checksalary(this.value);')); ?>    
                <?php echo $form->error($model, 'amount'); ?>   
            </li>
            <li class="col-sm-8">      
                <?php echo $form->textArea($model, 'payment_note',array('class'=>'tooltipster','title'=>' Note','data-label'=>'Payment Remark <span style="color:red">*</span>')); ?>    
                <?php echo $form->error($model, 'payment_note'); ?>   
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="salary_advance_close">Close</button>
    <?php
    $style='display:none;';
    if($model->id>0){
        $style='';
    }
    ?>
    <span id="span_salary_advance" style="<?php echo $style; ?>">
<?php
$url = Yii::app()->createUrl('/hr/salaryadvance/saveemployeeadvance');
echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
            t8.success("Saved Successfully!");
            $("#salary_advance_close").click();
            reloadTable("#tbl_employeesalaryadvance_details");
        } else { 

            $("#salary_advance-form .salary_advance-save-btn").prop("disabled", false);                      
            $("#salary_advance-form .salary_advance-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
            $.each(data, function(key, val) {
                t8.error(""+val+""); 

                }); 
            } 
        }',
    'beforeSend' => 'function(){
        $(".toast8-error").hide(); 
        var amount=$("#EmployeeSalaryAdvance_amount").val();
        if(parseInt(amount)<=0 || amount==""){
            t8.error("Amount must be greater than 0");
            return false;
        }else{
            $("#loader").show();
            $("#salary_advance-form .salary_advance-save-btn").prop("disabled", true);                      
            $("#salary_advance-form .salary_advance-save-btn").addClass("btn_loding").removeClass("btn-theme");            
            return true;
        }
        
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'salary_advance-save-btn btn btn-theme'));
?>
    </span>
</div>
<?php $this->endWidget(); ?>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript('getsalary', "function getsalary(employee_id){
    $('.toast8-error').hide(); 
    jQuery.ajax({
        'type'  : 'post',
        'dataType':'json',
        'data'  : 'employee_id='+employee_id,
        'url'  : '" . Yii::app()->createUrl("hr/salaryadvance/getsalary") . "',
        'cache': false,
        'success':function(data){
            if(data.status=='success'){
                $('#employee_salary').val(data.salary_amount);
                $('#EmployeeSalaryAdvance_function_type').val(data.functiontype);
                if(data.pending=='Y'){
                     $('#span_salary_advance').hide();
                     t8.error('Advance Repayment Exist');
                }else{
                    $('#span_salary_advance').show();
                }
            }else{
            }
        },
    });
};", CClientScript::POS_HEAD);
$cs->registerScript('checksalary', "function checksalary(amount){
    var salary_amount=$('#employee_salary').val();
    if(parseFloat(amount)>parseFloat(salary_amount)){
        $('#EmployeeSalaryAdvance_amount').val('');
        t8.error('Amount cannot be greater than salary '+salary_amount); 
    }
    
};", CClientScript::POS_HEAD);
?>










