<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'salaryupload-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_upload_salarycomponent = HrMasterUpload::model()->findByPK(24);
$upload_salarycomponet_size =$model_upload_salarycomponent->max_upload_size * 1024 * 1024;
?>
<style>
    .bott_dec span{
        display: block;
        line-height: 20px;
        font-weight: normal;
        font-size: 12px !important;
        color: #4d4c4c;
        padding-left: 20px;
        letter-spacing: 0.25px;
    }
</style>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">   
                <?php
                echo CHtml::dropdownlist('salary_branch_id_val', '', MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch <span style="color:red">*</span>', 'empty' => 'Select', 'title' => 'Please Select Branch', 'data-search' => true));
                ?>
            </li>
            <li class="col-sm-2"> 
                <?php
                echo CHtml::dropdownlist('salary_month_val', '',HrGenerelSettings::listMonths(), array('data-label' => 'Salary Month <span style="color:red">*</span>', 'empty' => 'Select', 'title' => 'Please Select Salary Month', 'data-search' => true));
                ?>
            </li>
            <li class="col-sm-2"> 
                <?php
                echo CHtml::dropdownlist('salary_year_val', '', HrGenerelSettings::listYears(0,1), array('data-label' => 'Salary Year <span style="color:red">*</span>', 'empty' => 'Select', 'title' => 'Please Select Salary Year', 'data-search' => true));
                ?>
            </li>
            <li class="col-sm-3">
                <?php
                $allowedExtensions = array("csv");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => 'saalrycsv_0_upload_csv',
                    'config' => array(
                        'action' => Yii::app()->createUrl('hr/' . Yii::app()->controller->id . '/UploadEmployeecsv', array('folder' => 'uploads/monthlysalary')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => $upload_salarycomponet_size,
                        'onStart' => "js:function(){}",
                        'class' => 'pull-right',
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            $('#salary_file').val(responseJSON.filename);
                        }",
                )));
                ?>
                <?php echo CHtml::hiddenField('salary_file', ''); ?>
            </li>
            <li class="col-sm-2">
                <div  id="csv_msg">
                </div>
            </li>
            <li class="col-sm-12 bott_dec pull-right">
                <span style="color:red;"><b>* Please avoid comma (,) in amount column *</b></span>
                <span style="color:red;">* All fields in the excel are Mandatory *</span>
                <span style="color:red;">* Fill out Variable Salary Type based upon the salary type master corresponding to <b><?= CHtml::link('Salary Type', array('massalarytype/index'), array('target' => '_blank')); ?></b> *</span>
                <span style="color:red;">* Upload files in .csv format *</span>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <?= CHtml::link('Download template', array('salary/downloadformat'), array('target' => '_blank','class'=>'btn btn-warning pull-left')); ?>
    <button type="button" class="btn btn-danger"id="salaryupload_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" id="btn_addmonthly_salary_cmpt" onclick="uploadsalarycomponent();">Save</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("uploadsalarycomponent", "function uploadsalarycomponent() {
    $('.toast8-error').hide(); 
        var branch  = $('#salary_branch_id_val').val();
        var month  = $('#salary_month_val').val();
        var year  = $('#salary_year_val').val();
        var filename  = $('#salary_file').val();
        if(branch!='' && month!='' && year!='' && filename!=''){
            jQuery.ajax({
                'data' : {'branch':branch,'month':month,'year':year,'filename':filename},
                'dataType':'json',
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/salary/savesalarycomponents') . "',
                'cache': false,
                'success': function(data) {
                    if (data.status == 'success') {
                        $('#loader').hide();
                        if(data.error!=''){
                            $('#csv_msg').html(data.link);
                            $.each(data.error, function(key, val) {
                                t8.error(''+val+''); 
                            }); 
                        }else{
                            t8.success('Salary Components Details Saved Successfully!');
                            reloadTable('#table_salary_component');
                            $('#salaryupload_close').click();	
                        }
                    }else if (data.status == 'error') {
                        t8.error(''+data.error+''); 
                    }
                }, 
                'beforeSend':function(){
                  $('#loader').show();                      
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });     
        }else{
            if(branch==''){
                t8.error('Select Branch');
            }else if(month==''){
                t8.error('Select month ');
            }else if(year==''){
                t8.error('Select year ');
            }else if(filename==''){
                t8.error('Upload File ');
            }
        }
    };", CClientScript::POS_HEAD);
?>


