<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'roomallocation-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="allocationdetail_table">
            <tr>
                <th>No</th> 
                <th>Building</th>
                <th>Room</th>
                <th>Bed Space</th>
                <th>Employee</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th class="text-center">
                    <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addRow($('#allocationdetail_table'));"><i class="fa fa-plus"></i></a></th>
            </tr>
             <?php           
                foreach ($model_details as $i => $detail):                  
            ?>
            <tr>
                <td><label><?php echo ($i+1); ?></label></td>                  
                <td>
                    <?php  echo $form->dropDownList($detail, "[" . $i . "]building_id",RoomSetting::getfloordetail(), array('class'=>'go','data-label' => 'Building/Floor','empty'=>'Select','onchange'=>'getroomdetail(this.id);',)); ?>                          
                </td>
                <td>
                    <?php  echo $form->dropDownList($detail, "[" . $i . "]room_id",array(), array('class'=>'go','data-label' => 'Room Name','empty'=>'Select','onchange'=>'getbedspacedetail(this.id);',)); ?>                         
                </td>
                <td>
                    <?php  echo $form->dropDownList($detail, "[" . $i . "]bedspace_id",array(), array('class'=>'go','data-label' => 'Bed Space','empty'=>'Select')); ?>                         
                </td>
                <td>
                    <?php  echo $form->dropDownList($detail, "[" . $i . "]employee_id",RoomAllocation::getemployee(), array('class'=>'go','data-label' => 'Employee Name','empty'=>'Select')); ?>                         
                </td>
                <td>
                    <?php  echo $form->textField($detail, "[" . $i . "]start_date", array('class'=>'datepicker go', 'title' => 'Start Date')); ?>                           
                </td>
                <td>
                    <?php  echo $form->textField($detail, "[" . $i . "]end_date", array('class'=>'datepicker go', 'title' => 'End Date')); ?>                           
                </td>
                <td class="text-center nw" width="1%" >
                       <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removeTableRow($(\'#allocationdetail_table\'),this)', 'title' => 'Remove this item','id'=>'allocationdelete_'.$i));
                    ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="roomallocation_close" data-dismiss="modal">Close</button>
<?php
$url = Yii::app()->createUrl('hr/roomsettings/SaveRoomallocation');
echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
            t8.success("Saved Successfully!");
            $("#roomallocation_close").click();
            reloadTable("#tbl_roomallocation_details");
        } else { 
            $("#roomallocation-form .roomallocation-save-btn").prop("disabled", false);                      
            $("#roomallocation-form .roomallocation-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
            $.each(data, function(key, val) {
                t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
            $("#loader").show();
            $("#roomallocation-form .roomallocation-save-btn").prop("disabled", true);                      
            $("#roomallocation-form .roomallocation-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
            $(".toast8-error").hide();
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'roomallocation-save-btn btn btn-theme'));
?>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("addRow", " function addRow(jQtable) {
        formId=   jQtable.attr('id');
        formIdStarter       =   jQtable.attr('id').split(/_(.+)?/)[0];
        lastId = jQtable.find('tr:last input:first').attr('id');
        thenum = lastId.match(/\d+/g);
        newId = Number(thenum) + 1;
        newrow= jQtable.find('tr:last').clone();
        newrow.find('label:first').html(newId+1);
        newrow.attr('class',newId);
        newrow.find('div,input,textarea,checkbox,td,select,.errorMessage,a').each(function() {
        this.id= this.id.replace(/\d+/,newId);                   
        (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style  =   '';});
        jQtable.append(newrow);
        $('#RoomAllocation_'+newId+'_start_date').datetimepicker({format: 'DD/MM/YYYY'});
        $('#RoomAllocation_'+newId+'_end_date').datetimepicker({format: 'DD/MM/YYYY'});
}", CClientScript::POS_HEAD);
$cs->registerScript("getroomdetail", " function getroomdetail(field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var floor_id=$('#RoomAllocation_'+row_field+'_building_id').val();
    jQuery.ajax({
        'dataType':'json', 
        'type': 'post',
        'url': '" . Yii::app()->createUrl('hr/roomsettings/getroomdetails') . "',
        'data': {'floor_id':floor_id},
        'cache': false,
        'success': function(data) {
            $('#RoomAllocation_'+row_field+'_room_id').html(data.roomdetail);
        }
    });

}", CClientScript::POS_HEAD);
$cs->registerScript("getbedspacedetail", " function getbedspacedetail(field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var room_id=$('#RoomAllocation_'+row_field+'_room_id').val();
    jQuery.ajax({
        'dataType':'json', 
        'type': 'post',
        'url': '" . Yii::app()->createUrl('hr/roomsettings/getbedspacedetails') . "',
        'data': {'room_id':room_id},
        'cache': false,
        'success': function(data) {
            $('#RoomAllocation_'+row_field+'_bedspace_id').html(data.bedspacedetail);
        }
    });

}", CClientScript::POS_HEAD);
?>