<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadSetting", '
        $(document).ready(function() {
        var table_id ="#tbl_bedspace_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/roomsettings/GetbedspaceList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD); 
    ?>
    <script>
        function AddContextMenu(row, datas) { 
            let items = {};
            if (datas[5].edit_button !== 0) {
                items.edit = {
                    name: "Edit",
                    icon: "fa-edit",
                    callback: function () {
                        loadPopupModal("hr/roomsettings/editbedspacedetail&room_id=" + datas[5].room_id, "Edit Bed Space Detail", "lg");
                    }
                };
            }
            if (Object.keys(items).length > 0) {
                $(row).contextMenu({
                    selector: 'td',
                    items: items
                });
            }
        }
    </script>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            Bed Space Details
            <div class="pull-right">
                <?php  if (isset(Yii::app()->user->haveHrPermissionOn['hr_bedspace_add']) ||  Yii::app()->user->authorised_user == 1) {?>
                    <a class="ad-btn" onclick="loadPopupModal('hr/roomsettings/addbedspace','Add New Bed Space','lg')" title="Add">                  
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_bedspace_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Building Name</th>
                            <th>Country</th>
                            <th>Location</th>
                            <th>Room Name</th>
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
    </section>
