<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadallocation", '
        $(document).ready(function() {
        var table_id ="#tbl_roomallocation_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            columns: [
                {className: ""},
                {className: "nw sl col-max-4"},
                {className: ""},
                {className: ""},               
                {className: ""},               
                {className: "" },
                {className: "" },
            ],
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/roomsettings/GetAllocationList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD); 
$cs->registerScript("deleteroom",  "function deleteroom(id){
    var r = confirm('Are you sure want to delete this allocation?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json', 
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/roomsettings/deleteroomallocation',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                     reloadTable('#tbl_roomallocation_details');
                    t8.success('Deleted SuccessFully!');
                    
                }else {
                    t8.error('Error in deleting data');                  
                }

               }

            });

        }
};", CClientScript::POS_HEAD);

    ?>
<script>
        function AddContextMenu(row, datas) { 
            let items = {};
            if (datas[7].edit_button !== 0) {
                items.edit = {
                    name: "Edit",
                    icon: "fa-edit",
                    callback: function () {
                        loadPopupModal("hr/roomsettings/editroomallocation&id=" + datas[7].id, "Edit Room Allocation", "lg");
                    }
                };
            }
            if (datas[7].delete_button !== 0) {
                items.delete = {
                    name: "Delete",
                    icon: "fa-trash",
                    callback: function () {
                       deleteroom(datas[7].id);
                    }
                };
            }
            if (Object.keys(items).length > 0) {
                $(row).contextMenu({
                    selector: 'td',
                    items: items
                });
            }
        }
    </script>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            Room Allocation
            <div class="pull-right">
                <?php  if (isset(Yii::app()->user->haveHrPermissionOn['hr_room_allocation_add']) ||  Yii::app()->user->authorised_user == 1) {?>
                    <a class="ad-btn" onclick="loadPopupModal('hr/roomsettings/createallocation','Add New Room Allocation','xl')" title="Add">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_roomallocation_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Building Name</th>
                            <th>Room</th>
                            <th>Bed Space</th>
                            <th>Employee Name</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
    </section>
