<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'employee-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
    $class_width="col-sm-2";
 if(!empty($model_general_setting) && $model_general_setting->hr_only=='Y'){
    $class_width="col-sm-3";
 }
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo CHtml::HiddenField('recruitment_id', $model_recruitment->id); 
                if($model_general_setting->auto_increment_employee_code=='Y'){
                    echo $form->dropdownlist($model, 'branch_or_sponsor_id',MasCompanyBranchSponsor::getCompanyBranches(),array('data-label'=>'Branch <span style="color:red">*</span>','empty'=>'Select','data-search'=>true,'onchange'=>'getcode(this.value);')); 
                }else{
                    echo $form->dropdownlist($model, 'branch_or_sponsor_id',MasCompanyBranchSponsor::getCompanyBranches(),array('data-label'=>'Branch <span style="color:red">*</span>','empty'=>'Select','data-search'=>true)); 
                }
                ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'employee_code', array('data-label' => 'Employee Code <span style="color:red">*</span>')); ?>
            </li>	
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'employee_biometric_code', array('data-label' => 'Biometric Code <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'subledger_account_no', array('data-label' => 'Subledger Account No')); ?>
            </li> 
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'first_name', array('data-label' => 'First Name')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'middle_name', array('data-label' => 'Middle Name')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'last_name', array('data-label' => 'Last Name')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropdownlist($model, 'gender', array('1' => 'Male', '2' => 'Female'), array('data-label' => 'Gender <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-3">
                <?php
                $date_of_birth = '';
                if ($model->date_of_birth != '' && $model->date_of_birth != '0000-00-00') {
                    $date_of_birth = date("d/m/Y", strtotime($model->date_of_birth));
                }
                echo $form->textField($model, 'date_of_birth', array('data-label' => 'Date of Birth <span style="color:red">*</span>', 'value' => $date_of_birth, 'class' => 'datepicker', 'onkeypress' => 'return false;'));
                ?>
            </li> 
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'date_join', array('data-label' => 'Joining Date <span style="color:red">*</span>', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-3">
                <div class="new-cst">
                    <div class="toggle-cst"><span class="cst-btn">+</span>
                        <div class="content-cst">
                            <div class="head" ripple="ripple" ripple-color="#FFF">
                                <h5>Add New Department</h5>
                            </div>
                            <div class="body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <?php echo CHtml::textField('department_name', '', array('data-label' => 'Department <span style="color:red;">*</span>')); ?>
                                    </div>
                                </div>
                                <div class="btn-wrap text-center">
                                    <a href="javascript:void(0);" class="plan-add-btn btn btn-theme go" onclick="AddMaster('MasDepartment', 'department')">SAVE</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="department_div">
                    <?php echo $form->dropdownlist($model, 'department', MasDepartment::getDepartment(), array('data-label' => 'Department <span style="color:red">*</span>', 'empty' => 'Select')); ?>
                </div>
            </li>
            <li class="col-sm-3">
                <div class="new-cst">
                    <div class="toggle-cst"><span class="cst-btn">+</span>
                        <div class="content-cst">
                            <div class="head" ripple="ripple" ripple-color="#FFF">
                                <h5>Add New Designation</h5>
                            </div>
                            <div class="body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <?php echo CHtml::textField('designation_name', '', array('data-label' => 'Designation <span style="color:red;">*</span>')); ?>
                                    </div>
                                </div>
                                <div class="btn-wrap text-center">
                                    <a href="javascript:void(0);" class="plan-add-btn btn btn-theme go" onclick="AddMaster('MasDesignation', 'designation')">SAVE</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="designation_div">
                    <?php echo $form->dropdownlist($model, 'designation', MasDesignation::getDesignation(), array('data-label' => 'Designation <span style="color:red">*</span>', 'empty' => 'Select')); ?>
                </div>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropdownlist($model, 'reporting_manager', ReportingManager:: getReportingManager(), array('data-label' => 'Reporting Manager ', 'empty' => 'Select', 'data-search' => true)); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'email2', array('data-label' => 'Personal Email')); ?>
            </li>
            <li class="<?php echo $class_width; ?>">
                <?php echo $form->textField($model, 'mobile', array('data-label' => 'Personal Mobile')); ?>
            </li>
            <li class="<?php echo $class_width; ?>">
                <?php echo $form->dropdownlist($model, 'currency', MasCurrency::getCurrency(), array('data-label' => 'Currency <span style="color:red">*</span>', 'options' => array(1 => array('selected' => 'selected')))); ?>
            </li>
            <?php
            if(!empty($model_general_setting) && $model_general_setting->hr_only=='Y'){
                echo $form->hiddenField($model, 'is_lead_owner', array('value' => 'N'));
            }else{
            ?>
            <li class="col-sm-2">
                <?php echo $form->dropDownList($model, 'is_lead_owner', array('Y' => 'Yes', 'N' => 'No'), array('data-label' => 'Is LeadOwner', 'empty' => 'Select')); ?>
            </li>
            <?php } ?>
        </ul>
    </div>
    <div id ="div_salary_item_details">
    <input type="hidden" id="salary_employee_id" value="<?php echo $model->id; ?>"/>
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task" id="salary_item_table">
            <tr>
                <th>No</th> 
                <th>Salary Type</th>
                <th>Date From</th>
                <th>Amount</th>
                <th class="text-center">
                    <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#salary_item_table'));"><i class="fa fa-plus"></i></a></th>
            </tr>
            <?php foreach ($model_salary as $i => $salary_detail): ?>
                <tr>
                    <td><label><?php echo ($i + 1); ?></label></td>
                    <td>
                        <?php echo $form->hiddenField($salary_detail, "[" . $i . "]id"); ?>
                        <?php echo $form->dropDownList($salary_detail, "[" . $i . "]salary_type", MasSalarytype::getAdditionwithrecurring(), array('class' => 'tooltipster go', 'empty' => 'Select', 'title' => 'Salary Type')); ?>                           
                        <?php echo $form->error($salary_detail, "[" . $i . "]salary_type"); ?>
                    </td>
                    <td>
                        <?php echo $form->textField($salary_detail, "[" . $i . "]amount", array('class' => 'disablecopypaste tooltipster go', 'title' => 'Amount', 'onkeypress' => 'return isNumberKey(event)')); ?>                           
                    </td>       
                    <td>
                      <?php  echo $form->textField($salary_detail, "[" . $i . "]valid_from", array('class'=>'datepicker form-control ','title' => 'Date From','onkeypress' => 'return false;')); ?>                           
                    </td>  
                    <td class="text-center nw" width="1%" >
                        <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeTableRow($(\'#salary_item_table\'),this)', 'title' => 'Remove this item', 'id' => 'salarydelete_' . $i));
                        ?>
                    </td>
                </tr>
                    <?php endforeach; ?>
        </table>
    </div>
</div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default " id="employee_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('/hr/recruitment/SaveEmployee');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Details Saved Successfully!");
                                         $("#employee_close").click();
                                        reloadTable("#tbl_employee_recruit_details");
                                    } else { 
                                       $("#employee-form .employee-save-btn").prop("disabled", false);
                                        $("#employee-form .employee-save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) {
                                                t8.error(""+val+""); 
                                        }); 
                                    } 
                            }',
        'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#employee-form .employee-save-btn").prop("disabled", true);
                                $("#employee-form .employee-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'employee-save-btn btn btn-theme'));
    ?>


</div>


<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("AddMaster", "function AddMaster(from,type)
        {
            //AddMaster('MasDesignation','designation')
            if(type == 'department'){
                var url = '" . Yii::app()->createUrl('hr/department/directadd') . "';
                var name = $('#department_name').val();
                var data = {'from':from,'name':name};
                if(name == ''){
                    alert('Please Fill All Fields!');
                   return false;
                }                
            }
            else if(type == 'designation'){
                var url = '" . Yii::app()->createUrl('hr/designation/directadd') . "';
                var name = $('#designation_name').val();
                var data = {'from':from,'name':name};
                if(name == ''){
                    alert('Please Fill All Fields!');
                   return false;
                }                
            }
           
            jQuery.ajax({
                'dataType':'json',              
                'data': data,
                'type':'post',
                'url': url,
                'cache': false,
                'success': function(data) {
                       if(data.status == 'success'){
                            if(from == 'MasDepartment' && type=='department'){
                                $('#department_div').html(data.drop);
                                $('.cst-btn.expand').click();
                            }
                            else if(from == 'MasDesignation' && type=='designation'){
                                $('#designation_div').html(data.drop);
                                $('.cst-btn.expand').click();
                            }
                            
                       }else{
                               $.each(data, function(key, val) {
                                        t8.error(''+val+''); 
                               }); 
                       }
                 } 

           });
       
        }", CClientScript::POS_HEAD);
$cs->registerScript("getcode", "function getcode(branch) {
        if(branch!=''){
            jQuery.ajax({
                'data' : {'branch':branch},
                'type':'post',
                'dataType':'json',
                'url': '" . Yii::app()->createUrl('hr/recruitment/codegenerate') . "',
                'cache': false,
                'success': function(data) {
                    $('#Employee_employee_code').addClass('filled');
                    $('#Employee_employee_code').val(data.code);
                }, 
                'beforeSend':function(){
                  $('#loader').show();                      
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });     
        }else{
            $('#Employee_employee_code').addClass('filled');
            $('#Employee_employee_code').val('');
        }
    };", CClientScript::POS_HEAD);
?>


