<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadleave", '
    function filterDataTable(employee_id,status) {
        var table_id ="#tbl_purchase_details";
        var branch_id = $("#purchase_branch_id").val();
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/purchaseproduct/GetList') . '",
                type: "POST",
                "data" : {
                    "employee_id" : employee_id,
                    "status" : status,
                    "branch_id" : branch_id
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  
        var employee_id= $("#purchase_employee_id").val();
        var status  = $("#purchase_status").val();		
        filterDataTable(employee_id,status);
        materializing(".material");
    })
', CClientScript::POS_HEAD);
$cs->registerScript("purchasedetails",  "function purchasedetails(){  
    $('#tbl_purchase_details').DataTable().destroy();
        var employee_id = $('#purchase_employee_id').val();
        var status  = $('#purchase_status').val();
        filterDataTable(employee_id,status);
};", CClientScript::POS_HEAD); 
?>
<script>
    function AddContextMenu(row, datas) { 
        let items = {};
        if (datas[7].approve_reject !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/purchaseproduct/approvepurchaserequest&final_level="+datas[7].final_level+'&level='+datas[7].level_no+'&id='+ datas[7].id, "Approve/Reject Purchase Request ", "lg");
                }
            };
        }
        if (datas[7].view_purchase !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/purchaseproduct/viewrequest&id="+datas[7].id, "View Purchase Request ", "lg");
                }
            };
        }
        if (datas[7].cancel_purchase !== 0) {
            items.cancel = {
                name: "Cancel",
                icon: "fa-remove",
                callback: function () {
                    loadPopupModal("hr/purchaseproduct/cancelpurchaserequest&id="+datas[7].id, "Cancel Purchase Request", "lg");
                }
            };
        }
        if (datas[7].direct_approval !== 0) {
            items.directapproval = {
                name: "Direct Approval",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/purchaseproduct/approvepurchaserequest&final_level=Y&level="+datas[7].last_level+ '&id='+ datas[7].id, "Approve/Reject Purchase Request ", "lg");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #purchaseProductindexdropdown .material-select-label {
        display: none;
    }
    </style> 
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            Purchase Request
            <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="purchaseProductindexdropdown"> 
          
            <span class="col-sm-3 pull-right"> 
            <?php
                $dropdown_list=array();
                $model_approval_status=HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select'=>'max(max_level) as max_level','condition' =>'employeedetail.branch_or_sponsor_id="'.$branch.'" and functionality_id="2"'));
                $max_level ="";
                if(!empty($model_approval_status)){
                $max_level=$model_approval_status->max_level;
                }
                $selected='H';
                if($max_level<=1){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Approved",
                        3 => "Level 1 Rejected",
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=2){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Approved",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Approved",
                        5 => "Level 2 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=3){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Approved",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Approved",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Approved",
                        7 => "Level 3 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=4){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Approved",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Approved",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Approved",
                        7 => "Level 3 Rejected", 
                        8 => "Level 4 Approved",
                        9 => "Level 4 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=5){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Approved",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Approved",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Approved",
                        7 => "Level 3 Rejected", 
                        8 => "Level 4 Approved",
                        9 => "Level 4 Rejected", 
                        10 => "Level 5 Approved",
                        11 => "Level 5 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }
                $dropdown_list['H']='Waiting For HR Approval';
                $dropdown_list['14']='Cancelled';
            echo CHtml::dropdownlist('purchase_status',$selected,$dropdown_list,  array('title' => 'Please Select Status','data-search'=>true,'onchange'=>'purchasedetails();','multiple'=>true)); 
            ?>	
            </span>
            <span class="col-sm-3 pull-right">       
                <?php echo CHtml::dropDownList("purchase_employee_id",'',Employee::getEmployee($branch), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'onchange'=>'purchasedetails();')); ?>  
            </span>
            </div>	
                <input type="hidden" id="purchase_branch_id" name="purchase_branch_id" value="<?php echo  $branch; ?>"/>
                <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_product_purchase_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                    <a class="ad-btn"  onclick="loadPopupModal('hr/purchaseproduct/create&branch=<?php echo  $branch; ?>','New Purchase Request','lg')"title="Add">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_purchase_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th class="text-center">No</th>
                            <th class="text-center">Employee Code</th>
                            <th class="text-center">Employee Name</th>
                            <th class="text-center">Apply Date</th> 
                            <th class="text-center">Payment Mode</th>
                            <th class="text-center">Total Amount</th>
                            <th class="text-center">Status</th>
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </div>
    </section>
