<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'product_purchase-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-5">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->hiddenField($model, 'status');
                echo $form->hiddenField($model,"function_type"); 
                echo $form->hiddenField($model,"last_approved_level"); 
                ?>
                <?php echo $form->dropDownList($model, 'employee_id',Employee::getEmployee($branch), array('data-label' => 'Employee <span style="color:red;">*</span>','empty'=>'Select','onchange'=>'getemployeedetails(this.value);','data-search'=>true)); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'payment_mode',array(1=>'Cash',2=>'From Salary'), array('data-label' => 'Payment Mode <span style="color:red;">*</span>','empty'=>'Select')); ?>
            </li>
        </ul>
        <div class="table-responsive">
            <table class="table table-hover table-bordered personal-task" id="pdt_purchase_table">
                <tr>
                    <th>No</th> 
                    <th>Product Name</th>
                    <th>Quantity</th>
                    <th>Rate</th>
                    <th>Total Amount</th>
                    <th class="text-center">
                        <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#pdt_purchase_table'));"><i class="fa fa-plus"></i></a></th>
                </tr>
                <?php           
                foreach ($model_detail as $i => $detail): ?>
                <tr>
        
                    <td><label><?php echo ($i+1); ?></label></td>
                    <td>
                       <?php echo $form->hiddenField($detail, "[" . $i . "]id"); ?>
                       <?php echo $form->hiddenField($detail, "[" . $i . "]cost"); ?>
                       <?php  echo $form->dropDownList($detail, "[" . $i . "]product_id",HrMasProduct::getProducts(), array('class'=>'tooltipster go','title' => 'Product','empty'=>'Select','onchange'=>'getproductdetails(this.id,this.value)')); ?>                           
                    </td> 
                    <td>
                        <?php  echo $form->textField($detail, "[" . $i . "]quantity", array('class'=>'tooltipster go text-right','title' => 'Quantity','onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateamount($("#pdt_purchase_table"));')); ?>                           
                    </td>
                    <td>
                        <?php  echo $form->textField($detail, "[" . $i . "]amount", array('class'=>'tooltipster go text-right','title' => 'Rate','readonly'=>true)); ?>                           
                    </td>
                    <td>
                        <?php  echo $form->textField($detail, "[" . $i . "]total_amount", array('class'=>'tooltipster go text-right','title' => 'Total Amount','readonly'=>true)); ?>                           
                    </td>
                    <td class="text-center nw" width="1%" >
                       <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removelineitem($(\'#pdt_purchase_table\'),this,this.id)', 'title' => 'Remove this item','id'=>'productpurchasedelete_'.$i));
                    ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </table>
            <table class="table table-hover table-bordered personal-task">
                <tfoot>
                    <tr>
                        <td class="text-bold text-right" style="width:71%">Grand Total</td>
                        <td class="text-bold text-right" style="width:24%">
                            <?php echo $form->textField($model,'grand_total', array('class' => 'form-control text-right','readonly'=>true)); ?>
                        </td>
                        <td style="width:5%"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="product_purchase_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" id="btn_apply_purchase_1" onclick="SavePurchase();">Save</button>
</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript('SavePurchase', 'function SavePurchase(){	
        jConfirm("Need Approval from other levels?", "Confirmation Dialog", function(r) {
            if (r == true) {
                $("#EmployeePurchase_status").val(1);
                $("#EmployeePurchase_last_approved_level").val(0);
                SaveProductRequest();
            }else{
                $("#EmployeePurchase_status").val(12);
                SaveProductRequest();
            }
        }); 
};', CClientScript::POS_HEAD);
$cs->registerScript('SaveProductRequest', 'function SaveProductRequest(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#product_purchase-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('hr/purchaseproduct/SaveProductRequest') . '",
        "success":function(data){
            if(data.status=="success"){  
                t8.success("Details Saved Successfully!");
                $("#product_purchase_close").click();
                reloadTable("#tbl_purchase_details");
            } else { 
               $.each(data, function(key, val) {
                    t8.error(""+val+""); 
               }); 
            } 
        },
        "beforeSend":function(){
            $("#loader").show();
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
$cs->registerScript("removelineitem", " function removelineitem(jQtable,evt,field_id) {
            var arr_fields= field_id.split('_');
            var row_field=arr_fields[1];
            var id=$('#EmployeePurchaseDetail_'+row_field+'_id').val();
            formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
            var num_rows    =   jQtable.find('tr:gt(0)').length;
            if(num_rows>1){
            var tr  =   $(evt).parent().parent();
            if(isRowEmpty(tr)) {
                if(id!=''){
                    jQuery.ajax({
                        'type': 'post',
                        'dataType': 'json',
                        'url': '" . Yii::app()->createUrl('hr/productpurchase/removeproductpurchase') . "',
                        'data': {'id':id} ,
                        'cache': false,
                        'success': function(data) {
                            if(data.status=='success'){
                                $(evt).parents('tr').remove();
                                var i=0;
                                jQtable.find('tr:gt(0)').each(function() {
                                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                    {
                                        old_id = $(this).attr('id');
                                        if(old_id!==undefined) {
                                            new_id = old_id.replace(/\d+/,i);
                                            $(this).attr('id',new_id);
                                        }
                                        old_name = $(this).attr('name');
                                        if(old_name!==undefined) {
                                            new_name = old_name.replace(/\d+/,i);
                                            $(this).attr('name',new_name);
                                        }
                                    });
                                    $(this).find('td:first label').html(++i);
                                });
                                t8.success('Deleted');
                                calculateamount($('#pdt_purchase_table'));    
                            }else{
                                t8.error('Deletion Not Possible, History Exist');
                            }
                        }
                    });
                }else{
                    $(evt).parents('tr').remove();
                    var i=0;
                    jQtable.find('tr:gt(0)').each(function() {
                        $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                        {
                            old_id = $(this).attr('id');
                            if(old_id!==undefined) {
                                new_id = old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                            }
                            old_name = $(this).attr('name');
                            if(old_name!==undefined) {
                                new_name = old_name.replace(/\d+/,i);
                                $(this).attr('name',new_name);
                            }
                        });
                        $(this).find('td:first label').html(++i);
                    });
                }
            }
        }else {
            alert('Atleast one item needed here');
        }
    }", CClientScript::POS_HEAD);
$cs->registerScript("getproductdetails", "function getproductdetails(field_id,product_id) {
        var arr_fields= field_id.split('_');
        var model_name= arr_fields[0];
        var row_field= arr_fields[1];  
         jQuery.ajax({
            'dataType':'json',
            'data': {'product_id':product_id}  ,
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/productpurchase/getproductdetails') . "',
            'cache': false,
            'success': function(data) {        
            if(data.status=='success'){
                $('#EmployeePurchaseDetail_'+row_field+'_cost').val(data.cost_price); 
                $('#EmployeePurchaseDetail_'+row_field+'_amount').val(data.selling_price); 
            }else{
                t8.error('Error'); 
            }

          }
        });
};", CClientScript::POS_HEAD);
$cs->registerScript("calculateamount", " function calculateamount(jQtable) {
        formIdStarter =   jQtable.attr('id').split(/_(.+)?/)[0];
        var qty,rate,amount,grand_total=0.00;
        jQtable.find('tr:gt(0)').each(function() {
            net = 0;
            qty =   $(this).find('[id $=_quantity]').val();
            rate =   $(this).find('[id $=_amount]').val();
            amount  =   (Number(qty)*Number(rate)).toFixed(2);
            if(Number(amount)>=0){
                grand_total+=Number(amount);
            }
            $(this).find('[id $=_total_amount]').val(Number(amount).toFixed(2));
        });
        $('#EmployeePurchase_grand_total').val(Number(grand_total).toFixed(2)); 
        return false;
    }", CClientScript::POS_HEAD);
$cs->registerScript("getemployeedetails", "function getemployeedetails(id) {
         jQuery.ajax({
                   'dataType':'json',
                    'data': {'id':id}  ,
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('hr/purchaseproduct/getemployeedetails') . "',
                    'cache': false,
                     'success': function(data) {
                      $('#EmployeePurchase_function_type').val(data.functiontype);
                      $('#EmployeePurchase_last_approved_level').val(data.maxlevel);
                    },
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();
                    }
        });
    };", CClientScript::POS_HEAD);
?>










