<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPayments", '$(document).ready(function() {
        var table_id ="#tbl_payroll_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/payment/GetPendingList') . '",
                type: "POST",
                cache : false,
            },
            columns: [            
                {className: "" },
                {className: ""},
                {className: "" },
                {className: ""}, 
                {className: ""}, 
                {className: "text-right"}, 
                {className: ""},
            ],
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
       
        if (datas[7].payments_type1 !== 0) {
            items.payement = {
                name: "Payment",
                icon: "fa-money",
                callback: function () {
                    loadPopupModal("hr/payment/releasepayment&id=" + datas[7].id+'&type='+datas[7].type+'&model='+datas[7].model, "PAYMENT", "lg");
                }
            };
        }
        if (datas[7].payments_type2 !== 0) {
            items.payments = {
                name: "Payment",
                icon: "fa-money",
                callback: function () {
                      loadPopupModal("hr/payment/releasepayment&id=" + datas[7].id+'&type='+datas[7].type+'&model='+datas[7].model, "PAYMENT", "lg");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame"> Payments
            <div class="pull-right">
            </div>
        </header>	
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_payroll_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Type</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Approval Date</th>
                            <th>Amount</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </div>
    </section>       
<style>
.form_field{
    width: 150px;
    background-color: #fff;
    background-image: none;
    border: 1px solid #ccc;
    border-radius: 4px;
    padding: 1px 10px;
    height: 36px;    
    margin-top: 2px;
    margin-right: 15px;
}
</style>    