<?php
$employees = Employee::model()->with('designationdetail')->findAll('t.isActive = :isActive', array(':isActive' => 'Y'));

// Organize employees by reporting manager
$employeeHierarchy = [];
$ceoId = null;
$ceo = null; // Initialize CEO variable
// Loop through each employee to organize the hierarchy and find the CEO
foreach ($employees as $employee) {
    // Check if the employee is the CEO based on their designation
    if ($employee->id == $employee->reporting_manager) {  // Assuming '29' is the CEO designation ID
        $ceoId = $employee->id; // Store the CEO ID
        $ceo = $employee; // Store the CEO object for later use
    }

    // Employees with a reporting manager are grouped under their manager's ID
    if ($employee->reporting_manager) {
        $employeeHierarchy[$employee->reporting_manager][] = $employee;
    } else {
        // If no reporting manager, treat '29' (CEO) as a key for top-level employees
        $employeeHierarchy[$ceoId][] = $employee;
    }
}

// Check if CEO is found
if ($ceoId == null) {
    echo 'CEO not found in the data.';
    return;
}

// Function to display the employees and their hierarchy
function display_employee_tree($employeeHierarchy, $managerId, $visitedEmployees = [], $ceoId) {
    // Check if the current manager has subordinates
    if (isset($employeeHierarchy[$managerId])) {
        // Start the list for this manager's subordinates
        echo '<ul>';

        // Loop through each subordinate under the current manager
        foreach ($employeeHierarchy[$managerId] as $employee) {
            // Avoid circular reference: if the employee has already been visited, skip them
            if (in_array($employee->id, $visitedEmployees)) {
                continue;
            }

            // Skip the CEO if we are already at the top level (to avoid repeating)
            if ($employee->id == $ceoId) {
                continue;
            }

            // Mark the employee as visited
            $visitedEmployees[] = $employee->id;

            // Display the employee's name and designation as a list item
            echo '<li><img src="uploads/profilephotos/' . (!empty($employee->profile_photo) ? $employee->profile_photo : 'emp.jpg') . '" width="50px" height="50px">  <a href="#">' . CHtml::encode($employee->de_first_name) . ' ( ' . CHtml::encode($employee->designationdetail->designation_name) . ' / ' . $employee->hr_code . ' )</a>';
            // Recursively call the function for the subordinates of this employee
            display_employee_tree($employeeHierarchy, $employee->id, $visitedEmployees, $ceoId);

            // Close the list item for this employee
            echo '</li>';
        }

        // Close the current manager's list of subordinates
        echo '</ul>';
    }
}
?>



<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Horizontal Organization Chart</title>
        <style>
        .tree ul li img{border-radius: 50%;}
        .tree li img{border-radius: 50%;}
        </style>


    </head>
    <body>
        <section class="panel" style="background-color:#F6F3EE; font-size: 10px;">
            <div class="panel-body">
                <div class="panel-heading clearfix panel-theame">
        <span id="title_rs_main"><i class="fa fa-tasks"></i> Organization Chart</span>
              </div>
                <div class="container" style="margin-top:30px;">
                    <div class="row">
                        <div class="col-md-12">
                            <ul id="tree1">
                                <?php
                                // Start displaying the hierarchy from the CEO directly
                                if ($ceoId != null) {  // If the CEO is found
                                    echo '<li ><img src="uploads/profilephotos/' . (!empty($ceo->profile_photo) ? $ceo->profile_photo : 'emp.jpg') . '" width="50px" height="50px">  <a href="#">' . CHtml::encode($ceo->de_first_name) . ' ( ' . CHtml::encode($ceo->designationdetail->designation_name) . ' / ' . $ceo->hr_code . ' )</a>';
                                    display_employee_tree($employeeHierarchy, $ceoId, [], $ceoId);  // Pass the employeeHierarchy, CEO's ID
                                    echo '</li>';
                                }
                                ?>       

                            </ul>    

                        </div>
                    </div> 
                </div>
        </section>




        <script>
            $.fn.extend({
                treed: function (o) {

                    var openedClass = 'glyphicon-minus-sign';
                    var closedClass = 'glyphicon-plus-sign';

                    if (typeof o != 'undefined') {
                        if (typeof o.openedClass != 'undefined') {
                            openedClass = o.openedClass;
                        }
                        if (typeof o.closedClass != 'undefined') {
                            closedClass = o.closedClass;
                        }
                    }
                    ;

                    // Initialize each of the top levels
                    var tree = $(this);
                    tree.addClass("tree");
                    tree.find('li').has("ul").each(function () {
                        var branch = $(this); // li with children ul
                        branch.prepend("<i class='indicator glyphicon " + closedClass + "'></i>");
                        branch.addClass('branch');
                        branch.on('click', function (e) {
                            if (this == e.target) {
                                var icon = $(this).children('i:first');
                                icon.toggleClass(openedClass + " " + closedClass); // toggle the icon
                                $(this).children('ul').toggle(); // toggle the visibility of the nested ul
                            }
                        })
                        branch.children('ul').hide(); // Initially hide the child lists (ul)
                    });

                    // Open only the first level for #tree1
                    if (tree.attr('id') === 'tree1') {
                        // Open the direct children of the root (first level only)
                        tree.find('> li:has(ul)').each(function () {
                            var icon = $(this).children('i:first');
                            icon.toggleClass(openedClass + " " + closedClass); // Open the branch icon
                            $(this).children('ul').show(); // Show the nested ul (children of the first level)
                        });
                    }

                    // Fire event from the dynamically added icon
                    tree.find('.branch .indicator').each(function () {
                        $(this).on('click', function () {
                            $(this).closest('li').click();
                        });
                    });

                    // Fire event to open branch if the li contains an anchor instead of text
                    tree.find('.branch>a').each(function () {
                        $(this).on('click', function (e) {
                            $(this).closest('li').click();
                            e.preventDefault();
                        });
                    });

                    // Fire event to open branch if the li contains a button instead of text
                    tree.find('.branch>button').each(function () {
                        $(this).on('click', function (e) {
                            $(this).closest('li').click();
                            e.preventDefault();
                        });
                    });
                }
            });

            // Initialization of treeviews
            $('#tree1').treed();

            $('#tree2').treed({openedClass: 'glyphicon-folder-open', closedClass: 'glyphicon-folder-close'});

            $('#tree3').treed({openedClass: 'glyphicon-chevron-right', closedClass: 'glyphicon-chevron-down'});
        </script>
    </body>
</html>
