<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'package-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-12">
                <?php
                echo $form->hiddenField($model, 'id');
                echo $form->textField($model, 'package_name', array('data-label' => 'Package Name <span style="color:red">*</span>'));
                ?>
            </li>	
            <li class="col-sm-12">
                <?php echo $form->textArea($model, 'description', array('data-label' => 'Description')); ?>
            </li>
            <li class="col-sm-12">
                <?php echo $form->dropdownlist($model, 'package_type', array('1' => 'Basic', '2' => 'Standard','3' => 'Premium'),array('data-label'=>'Package Type <span style="color:red">*</span>','empty'=>'Select')); ?>
            </li>
            <li class="col-sm-12">
                <?php 
                $selectedOptions = array();
                if (!empty($model) && !empty($model->package_details)) {
                    $arr_package_details = explode(",", $model->package_details);
                    foreach ($arr_package_details as $eachValue){
                        $selectedOptions[$eachValue] = array('selected' => 'selected');
                    }
                }
                echo $form->dropdownlist($model, 'package_details', HrModules::getsoftwarefunctions(), array('data-label' => 'Included Features <span style="color:red">*</span>', 'data-search' => true, 'multiple' => true, 'options' => $selectedOptions)); ?>
            </li> 
            <li class="col-sm-12">
                <?php echo $form->textField($model, "package_cost", array('data-label' => 'Cost', 'onkeypress' => 'return isNumberKey(event)')); ?>                           
            </li>
        </ul>
        <div class="modal-footer">
            <button type="button" class="btn btn-danger" id="package_close" data-dismiss="modal">Close</button>
            <?php
            $url = Yii::app()->createUrl('/hr/mastersettings/SavePackageDetails');
            echo CHtml::ajaxsubmitButton('Save', $url, array(
                'dataType' => 'json',
                'type' => 'post',
                'success' => 'function(data) {
                    if(data.status=="success"){  
                        t8.success("Package Details Updated Successfully!");
                        $("#package_close").click();
                    } else { 
                        $.each(data, function(key, val) {
                            t8.error(""+val+""); 
                        }); 
                    } 
                }',
                'beforeSend' => 'function(){
                    $("#loader").show();
                    $(".toast8-error").hide(); 
                    $("#package-form .package-save-btn").prop("disabled", true);
                    $("#package-form .package-save-btn").addClass("btn_loding").removeClass("btn-theme");
                }',
                'complete' => 'function(){
                            $("#loader").hide();
                            $("#package-form .package-save-btn").prop("disabled", false);
                            $("#package-form .package-save-btn").addClass("btn-theme").removeClass("btn_loding");
                        }'
                ), array('id' => 'mybtn' . rand(), 'class' => 'package-save-btn btn btn-theme'));
            ?>
        </div>
        <?php $this->endWidget(); ?>