<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'mas-salary-type-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>

<div class="tab-content">

    <div class="tab-pane active">

        <ul class="clearfix form-ul material">
            <li class="col-sm-4">    
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'salary_name', array('class' => 'tooltipster', 'data-label' => 'Name  <span style="color : red;"> * </span>', 'title' => 'Please enter Salary Type')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'salary_type', array('1' => 'Addition', '2' => 'Deduction'), array('empty' => 'Select', 'data-label' => 'Type<span style="color : red;"> * </span>', 'class' => 'tooltipster', 'title' => 'Please Select Salary Type')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'salary_occurence', array('1' => 'Variable/Single', '2' => 'Fixed'), array('empty' => 'Select', 'class' => 'tooltipster', 'data-label' => 'Occurence', 'title' => 'Please Select Occurence')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'consider_deduction', array('N' => 'No', 'Y' => 'Yes'), array('class' => 'tooltipster', 'title' => 'Please Select', 'data-label' => 'Absent Deduction<span style="color : red;"> * </span>')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo $form->dropDownList($model, 'consider_leave_settlement', array('N' => 'No', 'Y' => 'Yes'), array('class' => 'tooltipster', 'title' => 'Please Select', 'data-label' => 'Consider Leave Settlement / Encashment<span style="color : red;"> * </span>')); ?>
            </li>
            <?php
            $model_salary= EmployeeSalary::model()->find(array('condition' => 'salary_type="'.$model->id.'"'));
            if(!empty($model_salary) && $model_salary->id>0){
                $model->editable=1;
                echo $form->hiddenField($model, 'editable');
            }else{
            ?>
            <li class="col-sm-4">
                <?php
                    $model_salary= EmployeeSalary::model()->find(array('condition' => 'salary_type="'.$model->id.'"'));
                    if(!empty($model_salary)){
                        $model->editable=1;
                    }
                echo $form->dropDownList($model, 'editable', array('1' => 'No', '2' => 'Yes'), array('class' => 'tooltipster', 'title' => 'Please Select', 'data-label' => 'Editable<span style="color : red;"> * </span>')); ?>
            </li>
            <?php } ?>
        </ul>
        <div style="border-radius: 10px; border: 2px solid red; padding: 20px; width: auto;height:auto; ">
            <ul class="clearfix form-ul material">
                <li class="col-sm-8">
                    <?php
                    $model_mas_leave = new MasLeave();
                    $selectedOptions= array();
                    if(!empty($model) && $model->id>0){
                        $model_deduction_leave_details = $model_mas_leave->findAll(array('condition' => 'salary_deduction!="N" AND FIND_IN_SET(' . $model->id . ', salary_deduction_components) > 0'));
                        if(!empty($model_deduction_leave_details)){
                            foreach ($model_deduction_leave_details as $key => $value) {
                                $selectedOptions[] = $value->id;
                            }
                        }
                    }
                    echo CHtml::dropdownlist('leave_details_id',$selectedOptions,MasLeave::getLeavebybranchname(),array('data-label'=>'Leave Types(if deducted please select leave type)','multiple'=>true,'options' => $selectedsalaryOptions)); ?>
                </li>
            </ul> 
        </div>
    </div>
</div>

<div class="modal-footer">

    <button type="button" class="btn btn-danger" id="salarytype_close" data-dismiss="modal">Close</button>

    <?php
    $url = Yii::app()->createUrl('hr/massalarytype/SaveSalaryType');

    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
             t8.success("Saved Successfully!");
             $("#salarytype_close").click();
            reloadTable("#tbl_salarytype_details");
        } else { 

            $("#mas-salary-type-form .bank-save-btn").prop("disabled", false);
            $("#mas-salary-type-form .bank-save-btn").addClass("btn-theme").removeClass("btn_loding");
            $.each(data, function(key, val) {
                    t8.error(""+val+""); 
            }); 
        } 

    }',
        'beforeSend' => 'function(){
        $("#loader").show();
        $(".toast8-error").hide(); 
        $("#mas-salary-type-form .bank-save-btn").prop("disabled", true);
        $("#mas-salary-type-form .bank-save-btn").addClass("btn_loding").removeClass("btn-theme");
    }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'salarytype-save-btn btn btn-theme'));
    ?>


</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript('load', '
  $(document).ready(function() {
    $("#leave_details_id").multiselect({
      enableFiltering: true,
      includeSelectAllOption:true,
      enableCaseInsensitiveFiltering: true,
    });
  });', CClientScript::POS_HEAD);
?>


