<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getbranchmasterleave", "function getbranchmasterleave(branch){  
    jQuery.ajax({
     'dataType':'json',
     'data' : {'branch':branch},
     'type':'post',
     'url': '" . Yii::app()->createUrl('hr/masleave/getleavebybranch') . "',
     'success': function(data) {
        $('#li_leave_master_deatails').html(data.leave);
        loadLeavedetails(); 
        },
        'beforeSend':function(){
            $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
            });

        };", CClientScript::POS_HEAD);
$cs->registerScript("loadLeavedetails", "function loadLeavedetails(){  
    $('#tbl_masleave_details').DataTable().destroy();
    var branch= $('#leave_branch').val();      
    var leave_type= $('#leave_type').val();       
    filterDataTable(branch,leave_type); 
};", CClientScript::POS_HEAD);
$cs->registerScript("loadLeave", 'function filterDataTable(branch,leave_type){

    var table_id ="#tbl_masleave_details";
    var table = $(table_id).DataTable({
        scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
        pageLength      : 50,
        processing: true,
        ajax: {
            url: "' . Yii::app()->createUrl('hr/masleave/GetLeaveList') . '",
            type: "POST",
            "data" : {
                "branch" : branch,
                "leave_type" : leave_type     
                },
                cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                fixedHeader: {
                    headerOffset: $("header.main").outerHeight()
                    },

                    "fnCreatedRow": function (nRow, aData, iDataIndex) {
                        $(nRow).addClass("context-menu");
                        },
                        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                            AddContextMenu(nRow, aData);

                            if ( aData[8].status == "N" )  {  
                                $("td", nRow).addClass("bg-danger");
                            }      
                        }
                        });
                        $(".dataTables_scrollFoot").hide();
                    }
                    $(document).ready(function() {            
                        var branch= $("#leave_branch").val();  
                        var leave_type= $("#leave_type").val();
                        filterDataTable(branch,leave_type);
                          materializing(".material");
                    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[9].edit !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                loadPopupModal("hr/masleave/create&id=" + datas[9].id, datas[2], "lg");
                }
            };
        }
        if (datas[9].disable !== 0) {
            items.disable = {
                name: (datas[9].status== "Y") ? "Disable" : "Enable",
                icon: (datas[9].status == "Y") ? "fa-toggle-off" : "fa-toggle-on",
                callback: function () {
                    Disable(datas[9].id, datas[9].status);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
            selector: 'td',
                items: items
            });
        }
    }
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=hr/masleave/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_masleave_details').DataTable().ajax.reload()
                        t8.success('Disabled /Enabled SuccessFully!');
                    }
                }
            });
        }
    }
</script>
<style>
    #masleaveindexdropdown .material-select-label {
        display: none;
    }
    </style> 
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        Leave Type
            <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="masleaveindexdropdown"> 
                <span id="li_leave_master_deatails" class="col-sm-3 pull-right">
                <?php echo CHtml::dropdownlist('leave_type', '', MasLeave::getLeave(), array('data-label' => 'Leave Type', 'empty' => 'All', 'title' => 'Leave Type','data-search'=>true,'onchange' => 'loadLeavedetails();')); ?>
                </span>
                <span class="col-sm-3 pull-right">   
                <?php echo CHtml::dropdownlist('leave_branch', '', MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch','empty' => 'All Branches', 'title' => 'Please Select Branch','data-search'=>true, 'onchange' => 'getbranchmasterleave(this.value);')); ?>
             </span>
           </div>
                <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_leave_type_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <!-- <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/masleave/create', 'Add Leave Type', 'lg')"><i class="fa fa-plus"></i></button> -->
                  <a class="ad-btn"  onclick="loadPopupModal('hr/masleave/create','Add Leave Type','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
        
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_masleave_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch</th>
                        <th>Leave Name</th>
                        <th>Abbreviation</th>
                        <th>Leave Type</th>  
                        <th>Days</th>  
                        <th>Additional Leave</th>  
                        <th>Encashable</th>   
                        <th>Carry Forward</th>  
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
