<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'holiday-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
             <li class="col-sm-4">
                <?php
                 if($model->id) {
                    $stype = $model->branch_id;
                    $stype = explode(",", $stype);
                    foreach ($stype as $eachValue) {                                   
                      $selectedOptions[$eachValue] = array('selected'=>'selected');
                    }

                }else{
                    $model_branch= MasCompanyBranchSponsor::model()->findAll();
                    foreach ($model_branch as $eachValue){
                        $selectedOptions[$eachValue->id] = array('selected' => 'selected');
                    }
                }
                
                echo $form->dropdownList($model, 'branch_id',MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch','multiple'=>true,'options' => $selectedOptions)); ?>
            </li>
            <li class="col-sm-4">
                <?php
                if ($model->holiday_date != '' && $model->holiday_date != '0000-00-00') {
                    $model->holiday_date = date("d/m/Y", strtotime($model->holiday_date));
                }
                echo $form->textField($model, 'holiday_date', array('class' => 'datepicker', 'data-label' => 'Date <span style="color:red">*</span>'));
                echo $form->hiddenField($model, 'id');
                 ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropdownList($model, 'notify',array('Y'=>'Y','N'=>'N'), array('data-label' => 'Notify Employee<span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-12">
                <?php echo $form->textArea($model, 'holiday_description', array('data-label' => 'Holiday Description <span style="color:red">*</span>')); ?>
            </li>

        </ul>
    </div>

</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="holiday_close">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/masholiday/Save');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){  
                 t8.success("Saved Successfully!");
                 $("#holiday_close").click();
                 reloadTable("#tbl_holiday_details");
            } else { 
                $("#holiday-form .holiday-save-btn").prop("disabled", false);                      
                $("#holiday-form .holiday-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
                $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                    }); 
            } 
                            }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $("#holiday-form .holiday-save-btn").prop("disabled", true);                      
            $("#holiday-form .holiday-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
            $(".toast8-error").hide(); 
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'holiday-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript('addbranch', '
  $(document).ready(function() {
    $("#MasHoliday_branch_id").multiselect({
      enableFiltering: true,
      includeSelectAllOption:true,
      enableCaseInsensitiveFiltering: true,
    });
  });', CClientScript::POS_HEAD);
  ?>





