<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadmigratedleave", 'function filterDataTable(employee_id,leavetype) {
        var table_id ="#tbl_employeemigratedleave_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/leavemigration/GetEmployeeLeave') . '",
                type: "POST",
                "data" : {
                    "employee_id" : employee_id,
                    "leavetype" : leavetype                    
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	 
        var employee_id       = $("#mig_employee_id").val();
        var leavetype        = $("#mig_leavetype").val();		
        filterDataTable(employee_id,leavetype);
         materializing(".material"); 
    })
	
	', CClientScript::POS_HEAD);
	
    $cs->registerScript("Leavedetails",  "function Leavedetails(){  
        $('#tbl_employeemigratedleave_details').DataTable().destroy();
        var employee_id       = $('#mig_employee_id').val();
        var leavetype        = $('#mig_leavetype').val();      
        filterDataTable(employee_id,leavetype);
   
};", CClientScript::POS_HEAD); 
$cs->registerScript("deleteleave", "function deleteleave(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {	
            jQuery.ajax({
                'type'      : 'post',
                'data'      : 'id=' + id,
                'dataType'  : 'json',  
                'url'       : $('#liveSite').val()+'index.php?r=hr/leavemigration/deleteleave',
                'cache'     : false,
                'success'   :function(data){
                    if(data.status=='success'){
                        t8.success('Deleted SuccessFully!');
                        reloadTable('#tbl_employeemigratedleave_details');
                    }else {
                        t8.error('Error while Delete');
                    }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[7].migration_view !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/leavemigration/viewleavedetails&id=" + datas[7].id, "Employee Leave Details", "lg");
                }
            };
        }
        if (datas[7].migration_delete !== 0) {
            items.Delete = {
                name: "Delete",
                icon: "fa-trash",
                callback: function () {
                    deleteleave(datas[7].id);
                }
            };
        }
        if (datas[7].migration_download !== 0) {
            items.medicalcertificate = {
                name: "Attachment",
                icon: "fa-download",
                callback: function () {
                     window.open($('#liveSite').val() + "/index.php?r=hr/leavemigration/downloadDocument&frm=2&id=" + datas[7].id, "_blank");
                }
            };
        }
        if (datas[7].migration_download !== 0) {
            items.approvaldocument = {
                name: "Download Approval Document",
                icon: "fa-download",
                callback: function () {
                     window.open($('#liveSite').val() + "/index.php?r=hr/leavemigration/downloadDocument&frm=1&id=" + datas[7].id, "_blank");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #employeeleavesettlementindexdropdown .material-select-label {
        display: none;
    }
    </style>

    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame"> Migrated Leave Details
            <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeleavesettlementindexdropdown">   
             <span class="col-sm-3 pull-right">  
                <?php echo CHtml::dropdownlist('mig_leavetype','',MasLeave::getLeave(),  array('prompt' => 'All Leaves','title' => 'Leave Type','data-search'=>true,'onchange'=>'Leavedetails();')); ?>  &nbsp;			
             </span>
             <span class="col-sm-3 pull-right">  
                <?php echo CHtml::dropDownList("mig_employee_id",'',Employee::getEmployee(), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'onchange'=>'Leavedetails();')); ?>            
             </span>
            </div>
                <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_migration_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                     <a class="ad-btn" title="Add" onclick="loadPopupModal('hr/leavemigration/create','Add Migrated Leave','xl')">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_employeemigratedleave_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Leave Type</th>  
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>No of Days</th>                                             
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
