<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'migratedemployeeleave-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_upload_leave_migration_medical = HrMasterUpload::model()->findByPK(18);
$model_upload_leave_migration_approval = HrMasterUpload::model()->findByPK(19);
$sizeLimitleaveapprovalsize = $model_upload_leave_migration_approval->max_upload_size * 1024 * 1024;
$sizeLimitleavemedicalsize = $model_upload_leave_migration_medical->max_upload_size * 1024 * 1024;?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->hiddenField($model, 'leave_status', array('value' => 4)); ?>
                <?php
                echo $form->dropDownList($model, 'employee_id', Employee::getemployee(), array('empty' => 'Select', 'data-label' => 'Employee Name', 'data-search' => 'true'));
                ?>     
                <?php echo CHtml::hiddenField("leave_apply_end_date", $start_date); ?>
            </li>
            <li class="col-sm-2">
                <?php
                echo $form->dropDownList($model, 'leave_type', MasLeave::getLeave(), array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Type','empty'=>'Select', 'data-search' => 'true'));
                ?>
            </li>
            <li class="col-sm-2">
                <?php echo CHtml::checkBox('half_leave', '', array('class' => 'halfdayleave tooltipster', 'data-label' => 'Half Day', 'onclick' => 'halfdayleave();')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'leave_start_date', array('class' => 'datepicker', 'title' => 'Leave Start Date', 'data-label' => 'Start Date', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-2">
                <?php
                echo $form->textField($model, 'leave_end_date', array('class' => 'datepicker', 'title' => 'Leave End Date', 'data-label' => 'End Date', 'onkeypress' => 'return false;'));
                ?>
            </li>
            <li class="col-sm-1">
                <?php echo $form->textField($model, 'no_days', array('class' => 'tooltipster', 'title' => 'No of Days', 'data-label' => 'Days')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo $form->textArea($model, 'leave_reason', array('class' => 'tooltipster', 'title' => 'Leave Reason', 'data-label' => 'Leave Reason')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->checkBox($model, 'ticket_applied', array('class' => 'tooltipster', 'class' => '', 'title' => 'Ticket', 'data-label' => 'Ticket')); ?>
            </li>
            <?php  if($model_upload_leave_migration_medical->isActive=='Y'){ ?>
            <li class="col-sm-2" id="medical_certificate">
                <label class="">Medical Certificate</label>
                <?php
                $allowedExtensions = array("csv", "png", "txt", "pdf", "doc", "docx", "jpg", "jpeg", "gif");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                        'action' => Yii::app()->createUrl('hr/'.Yii::app()->controller->id . '/upload', array('folder' => 'uploads/leavedocument')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => 6 * 1024 * 1024,
                        'onStart' => "js:function(){}",
                        'onComplete' => "js:function(id, fileName, responseJSON){
                                $('#HrEmployeeLeaveMigrated_medical_certificate').val(responseJSON.filename); 
                           }",
                    )
                ));
                ?>
                <?php echo $form->hiddenField($model, 'medical_certificate'); ?>
            </li>
            <?php } ?>
            <?php  if($model_upload_leave_migration_approval->isActive=='Y'){ ?>
                <li class="col-sm-2">
                    <label class="">Approval Document</label>
                    <?php
                    $allowedExtensions = array("csv", "png", "txt", "pdf", "doc", "docx", "jpg", "jpeg", "gif");
                    $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                        'id' => rand(),
                        'config' => array(
                            'action' => Yii::app()->createUrl('hr/'.Yii::app()->controller->id . '/upload', array('folder' => 'uploads/leavedocument')),
                            'multiple' => false,
                            'allowedExtensions' => $allowedExtensions,
                            'sizeLimit' => $sizeLimitleaveapprovalsize,
                            'onStart' => "js:function(){}",
                            'onComplete' => "js:function(id, fileName, responseJSON){
                                    $('#HrEmployeeLeaveMigrated_leave_approval_document').val(responseJSON.filename); 
                               }",
                        )
                    ));
                    ?>
                    <?php echo $form->hiddenField($model, 'leave_approval_document'); ?>
                </li>
            <?php } ?>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="leave_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" id="btn_apply_leave_1" onclick="Saveleavedetails();">Save</button>
</div>
<?php $this->endWidget(); ?>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    var date_value = $('#leave_apply_end_date').val().split('/');
    var max_date = new Date(date_value[2], date_value[1] - 1, date_value[0]);
        $('#HrEmployeeLeaveMigrated_leave_start_date').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'}).val('');
        $('#HrEmployeeLeaveMigrated_leave_end_date').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'}).val('');
});", CClientScript::POS_HEAD);
$cs->registerScript('Saveleavedetails', 'function Saveleavedetails(){	
    jConfirm("Save this Leave Details?", "Confirmation Dialog", function(r) {
        if (r == true) {
            jQuery.ajax({
                "dataType":"json",
                "data" : $("#migratedemployeeleave-form").serialize(),
                "type"  : "post",
                "url": "' . Yii::app()->createUrl('hr/leavemigration/SaveMigratedleave') . '",
                "success":function(data){
                    if(data.status=="success"){  
                        t8.success("Details Saved Successfully!");
                        $("#leave_close").click();
                        reloadTable("#tbl_employeemigratedleave_details");
                    } else { 
                       $.each(data, function(key, val) {
                               t8.error(""+val+""); 
                       }); 
                    } 
                },
                "beforeSend":function(){
                    $("#loader").show();
                },
                "complete":function(){
                    $("#loader").hide();
                }
            });
        }
    }); 
};', CClientScript::POS_HEAD);
$cs->registerScript("halfdayleave", "function halfdayleave() {
    var days = $('#HrEmployeeLeaveMigrated_no_days').val();  
    var chks = $(\"input[name='half_leave']:checked\").length;
    var available_leave=$('#available_leave').val();   
    if (chks>0)  {
        var leave_apply=days-0.5;
        if(leave_apply>0){
            $('#HrEmployeeLeaveMigrated_no_days').val(leave_apply);  
        }else{
            $('#HrEmployeeLeaveMigrated_no_days').val(0);  
            $('#HrEmployeeLeaveMigrated_leave_end_date').val('');
        }
    } else {
        if(days>0){
            var leave_apply=parseFloat(days)+parseFloat(0.5);
            if(Number(leave_apply)>Number(available_leave)){
                $('#HrEmployeeLeaveMigrated_no_days').val(available_leave); 
                $('.halfdayleave ').prop('checked',true);
                t8.error('Leaves not availabe.Maximum available leave is '+available_leave);  
            }else if(leave_apply>0){
                $('#HrEmployeeLeaveMigrated_no_days').val(leave_apply);  
            }else{
                $('#HrEmployeeLeaveMigrated_no_days').val(0);  
            }
        }else{
                $('#HrEmployeeLeaveMigrated_no_days').val(0);  
        }
    }
    $('#HrEmployeeLeaveMigrated_no_days').addClass('filled');  
};", CClientScript::POS_HEAD);
$cs->registerScript("Checkstartdate", "
    $('#HrEmployeeLeaveMigrated_leave_start_date,#HrEmployeeLeaveMigrated_leave_end_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {
        $('#HrEmployeeLeaveMigrated_leave_end_date').data('DateTimePicker').minDate(e.date);
        $('#HrEmployeeLeaveMigrated_leave_end_date').addClass('filled'); 
        var start_date=$('#HrEmployeeLeaveMigrated_leave_start_date').val();   
        var end_date=$('#HrEmployeeLeaveMigrated_leave_end_date').val();  
        var employee_id=$('#HrEmployeeLeaveMigrated_employee_id').val(); 
        var leave_type=$('#HrEmployeeLeaveMigrated_leave_type').val(); 
        var chks = $(\"input[name='half_leave']:checked\").length;
        var checkbox=0;
        if (chks>0){
            checkbox=1;
        }
        if(leave_type!='' && employee_id!=''){
            jQuery.ajax({
                'dataType':'json', 
                'data': {'employee_id':employee_id,'start_date':start_date,'end_date':end_date,'checkbox':checkbox}  ,
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/leavemigration/checkleavedate') . "',    
                'cache': false,
                'success': function(data) {    
                    if(data.status=='success'){                        
                        if(data.dateerror==8){
                            jConfirm('Available leave is '+data.normal_leave+' and applied for '+data.days+' leaves.Salary deducted for '+data.salary_deduction_leave+' leaves.Do you want to continue?', 'Confirmation Dialog', function(r) {
                                if (r == true) {
                                    $('#HrEmployeeLeaveMigrated_no_days').addClass('filled'); 
                                    $('#HrEmployeeLeaveMigrated_normal_leave').val(data.normal_leave); 
                                    $('#HrEmployeeLeaveMigrated_salary_deduction_leave').val(data.salary_deduction_leave); 
                                    $('#HrEmployeeLeaveMigrated_no_days').val(data.days); 
                                }else{
                                    $('#HrEmployeeLeaveMigrated_no_days').addClass('filled'); 
                                    $('#HrEmployeeLeaveMigrated_leave_start_date').val(''); 
                                    $('#HrEmployeeLeaveMigrated_leave_end_date').val('');
                                    $('#HrEmployeeLeaveMigrated_no_days').val(0); 
                                    $('#HrEmployeeLeaveMigrated_normal_leave').val(0); 
                                    $('#HrEmployeeLeaveMigrated_salary_deduction_leave').val(0); 
                                }
                            });
                        }else{
                            $('#HrEmployeeLeaveMigrated_no_days').addClass('filled'); 
                            $('#HrEmployeeLeaveMigrated_no_days').val(data.days); 
                            $('#HrEmployeeLeaveMigrated_normal_leave').val(data.days); 
                            $('#HrEmployeeLeaveMigrated_salary_deduction_leave').val(0); 
                           //$(\"input[name='EmployeeLeaveDetail[half_day]']:checked\").prop('checked',false);
                        }
                    }else{
                        if(data.dateerror==1){
                            t8.error('Select Start Date');  
                        }else if(data.dateerror==2){
                           // t8.error('Select End Date');  
                        }else if(data.dateerror==3){
                            t8.error('Leave applied in this date range');  
                        }else if(data.dateerror==4){
                            $('#HrEmployeeLeaveMigrated_no_days').addClass('filled'); 
                            t8.error('Leaves not availabe.Maximum available leave is '+data.max_leave_available);  
                            $('#HrEmployeeLeaveMigrated_leave_end_date').val(start_date);   
                            $('#HrEmployeeLeaveMigrated_no_days').val(1);   
                            $('#HrEmployeeLeaveMigrated_normal_leave').val(1); 
                            $('#HrEmployeeLeaveMigrated_salary_deduction_leave').val(0); 
                        }else if(data.dateerror==5){
                            t8.error('Leave should be applied before '+data.applybefore);
                            $('#HrEmployeeLeaveMigrated_no_days').addClass('filled'); 
                            $('#HrEmployeeLeaveMigrated_leave_start_date').val('');   
                            $('#HrEmployeeLeaveMigrated_leave_end_date').val('');   
                            $('#HrEmployeeLeaveMigrated_no_days').val(0);   
                            $('#HrEmployeeLeaveMigrated_normal_leave').val(0); 
                            $('#HrEmployeeLeaveMigrated_salary_deduction_leave').val(0); 
                        }else if(data.dateerror==6){
                            t8.error('Attendance marked as present for '+data.attendancedate);  
                            $('#HrEmployeeLeaveMigrated_no_days').addClass('filled'); 
                            $('#HrEmployeeLeaveMigrated_leave_start_date').val('');   
                            $('#HrEmployeeLeaveMigrated_leave_end_date').val('');   
                            $('#HrEmployeeLeaveMigrated_no_days').val(0);   
                            $('#HrEmployeeLeaveMigrated_normal_leave').val(0); 
                            $('#HrEmployeeLeaveMigrated_salary_deduction_leave').val(0); 
                        }else if(data.dateerror==7){
                            t8.error('Leave Balance Record not Present.Contact HR');  
                            $('#HrEmployeeLeaveMigrated_no_days').addClass('filled'); 
                            $('#HrEmployeeLeaveMigrated_leave_start_date').val('');   
                            $('#HrEmployeeLeaveMigrated_leave_end_date').val('');   
                            $('#HrEmployeeLeaveMigrated_no_days').val(0);   
                            $('#HrEmployeeLeaveMigrated_normal_leave').val(0); 
                            $('#HrEmployeeLeaveMigrated_salary_deduction_leave').val(0); 
                        }else if(data.dateerror==9){
                            t8.error('Maximum leave limit for this leave type is '+data.max_leave_available);  
                            $('#HrEmployeeLeaveMigrated_no_days').addClass('filled'); 
                            $('#HrEmployeeLeaveMigrated_leave_end_date').val('');   
                            $('#HrEmployeeLeaveMigrated_no_days').val(0);  
                            $('#HrEmployeeLeaveMigrated_normal_leave').val(0); 
                            $('#HrEmployeeLeaveMigrated_salary_deduction_leave').val(0); 
                        }
                    }
                },
                'beforeSend':function(){
                    $('.toast8-error').hide(); 
                    $('#loader').show();
                },
                'complete':function(){
                    $('#loader').hide();
                }
            });
        }else{
            if(employee_id==''){
                 t8.error('Select Employee'); 
                 $('#HrEmployeeLeaveMigrated_leave_start_date').val('');   
            }else if(leave_type==''){
                 t8.error('Select Leave'); 
                 $('#HrEmployeeLeaveMigrated_leave_start_date').val('');   
            }else if(available_leave<=0){
                 t8.error('No Leaves available'); 
                 $('#HrEmployeeLeaveMigrated_leave_start_date').val('');   
            }
        }
    });", CClientScript::POS_HEAD);

?>




