<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadleaveencashment", '
    function filterDataTable(employee_id,status) {
        var table_id ="#tbl_employeeleaveenacashment_details";
        var branch_id       = $("#leaveencashment_branch_id").val();
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/leave/GetEmployeeLeaveEncashment') . '",
                type: "POST",
                    "data" : {
                    "status" : status,"employee_id":employee_id,"branch_id":branch_id                  
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
	  $(document).ready(function() {  		  
        var status  = $("#leave_encashment_status").val();	
        var employee_id  = $("#encashment_employee_id").val();
        filterDataTable(employee_id,status);
        materializing(".material"); 
    })
	
	', CClientScript::POS_HEAD);

$cs->registerScript("encashmentdetails", "function encashmentdetails(){  
    $('#tbl_employeeleaveenacashment_details').DataTable().destroy();
    var status  = $('#leave_encashment_status').val();
    var employee_id  = $('#encashment_employee_id').val();
    filterDataTable(employee_id,status);
   
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[9].encash_approve !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/leave/encashmentapproval&final_level=Y&level=" + datas[9].final_leve1 + "&level=" + datas[9].level_no + "&id=" + datas[9].id, "Approve/Reject Leave Encashment", "xl");
                }
            };
        }
        if (datas[9].encash_view !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/leave/viewleaveencashmentdetails&id=" + datas[9].id, "Leave Encashment Details", "lg");
                }
            };
        }
        if (datas[9].encash_direct_approve !== 0) {
            items.adminapprove = {
                name: "Direct Approval",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/leave/encashmentapproval&final_level=Y&level=" + datas[9].last_level + "&id=" + datas[9].id, "Approve/Reject Leave Encashment", "xl");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #employeeleaveencasmentindexdropdown .material-select-label {
        display: none;
    }
</style>

<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">Leave Encashment
        <div class="pull-right dis-flx">
            <input type="hidden" id="leaveencashment_branch_id" name="leaveencashment_branch_id" value="<?php echo $branch; ?>"/>
            <div class="material col-sm-12 pd-zero" id="employeeleaveencasmentindexdropdown"> 

                <span class="col-sm-3 pull-right"> 
                    <?php
                    $dropdown_list = array();
                    $model_approval_status = HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select' => 'max(max_level) as max_level', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" and functionality_id="9"'));
                    $max_level = 0;
                    if (!empty($model_approval_status)) {
                        $max_level = $model_approval_status->max_level;
                    }
                    $selected = 'H';
                    if ($max_level <= 1) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 2) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 3) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 4) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            8 => "Level 4 Confirmed",
                            9 => "Level 4 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 5) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Confirmed",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Confirmed",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Confirmed",
                            7 => "Level 3 Rejected",
                            8 => "Level 4 Confirmed",
                            9 => "Level 4 Rejected",
                            10 => "Level 5 Confirmed",
                            11 => "Level 5 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    }
                    $dropdown_list['H'] = 'Waiting For HR Approval';
                    $dropdown_list['14'] = 'Payment Released';
                    echo CHtml::dropdownlist('leave_encashment_status', $selected, $dropdown_list, array('title' => 'Please select Status', 'data-search' => true, 'multiple' => true, 'onchange' => 'encashmentdetails()'));
                    ?>
                </span>
                <span class="col-sm-3 pull-right">       
                    <?php echo CHtml::dropDownList("encashment_employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select Employee', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true, 'onchange' => 'encashmentdetails();')); ?>                           
                </span>
            </div>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn"  onclick="loadPopupModal('hr/leave/createleaveencashment&branch=<?php echo $branch; ?>', 'Leave Encashment', 'lg')">
                                  
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_employeeleaveenacashment_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Code</th>
                        <th>Employee Name</th>
                        <th>Leave Type</th>
                        <th>Apply Date</th>  
                        <th>Approve Date</th>  
                        <th>Encashment Days</th>  
                        <th>Amount</th>
                        <th>Status</th>                                                
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
