<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadleave", '
    function filterDataTable(employee_id,leavetype,branch_id) {
        var table_id ="#tbl_employeeleavebalance_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/leave/GetEmployeeLeaveBalance') . '",
                type: "POST",
                "data" : {
                    "employee_id" : employee_id,
                    "leavetype" : leavetype,
                    "branch_id" : branch_id                    
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	
        var employee_id       = $("#employee_id").val();
        var leavetype        = $("#leavetype").val();	
        var branch_id       = $("#leave_branch_id").val();
      filterDataTable(employee_id,leavetype,branch_id);
      materializing(".material"); 
    })
	
	', CClientScript::POS_HEAD);
	
	$cs->registerScript("Leavedetails",  "function Leavedetails(){  
    $('#tbl_employeeleavebalance_details').DataTable().destroy();
        var employee_id       = $('#employee_id').val();
	var branch_id       = $('#leave_branch_id').val();
        var leavetype        = $('#leavetype').val();
    filterDataTable(employee_id,leavetype,branch_id);
   
};", CClientScript::POS_HEAD); 
$cs->registerScript("excelemployeeleave", "function excelemployeeleave(){
    var employee_id       = $('#employee_id').val();
    var branch_id       = $('#leave_branch_id').val();
    var leavetype        = $('#leavetype').val();
    window.open($('#liveSite').val()+'index.php?r=hr/excel/employeeleavebalanceexcel&employee_id='+employee_id+'&branch_id='+branch_id+'&leavetype='+leavetype, '_blank');
}", CClientScript::POS_HEAD);        
?>
<style>
    #employeeappraisalindexdropdown .material-select-label {
        display: none;
    }
    </style>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">Leave Balance
            <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="employeeappraisalindexdropdown">    
            <span class="col-sm-1 pull-right">    
            <button class="btn btn-sm btn-theme" onclick="excelemployeeleave()" title="Excel">
                <i class="fa fa-file-excel-o"></i>
            </button>
             </span>
            <span class="col-sm-3 pull-right"> 
           <?php echo CHtml::dropdownlist('leavetype','',MasLeave::getParentLeave($branch),  array('prompt' => 'All Leaves','title' => 'Leave Type','data-search'=>true,'onchange'=>'Leavedetails();')); ?>  &nbsp;
            </span>
            
            <span class="col-sm-3 pull-right"> 
                <?php echo CHtml::dropDownList("employee_id",'',Employee::getEmployee($branch), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'onchange'=>'Leavedetails();')); ?>  
            </span>

        </div>
           <input type="hidden" id="leave_branch_id" name="leave_branch_id" value="<?php echo  $branch; ?>"/>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_employeeleavebalance_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Leave Type</th>  
                            <th>Leave Opening</th>  
                            <th>Current Balance</th>
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </div>
    </section>
