<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'employeeinprocess-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo $form->hiddenField($model_inprocess, 'id'); ?>
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo CHtml::hiddenField('doc_id',$model->document_id); ?>
                <?php echo CHtml::hiddenField('master_id',$model->id); ?>
                <?php echo CHtml::hiddenField('emp_id',$model->employee_id); ?>
                <?php echo $form->textField($model, 'doc_name', array('value'=>$model->document->document_name,'data-label' => 'Document Name  <span style="color : red;"> * </span>','readonly'=>true)); ?>
            </li>
            <li class="col-sm-6">
                <?php echo $form->dropDownList($model_inprocess, 'stage_id', MasExpiryStatus::getEmployeeExpiryStatus($model->document_id,$model->employee_id), array('data-label' => 'Document Type <span style="color : red;"> * </span>', 'prompt' => 'Select','onchange'=>'filldetails(this.value);')); ?>
            </li>
            <?php
            if ($model_inprocess->start_date!='0000-00-00' && $model_inprocess->start_date!='') {
                $model_inprocess->start_date = date("d/m/Y", strtotime($model_inprocess->start_date));
            }
            if ($model_inprocess->end_date!='0000-00-00' && $model_inprocess->end_date!='') {
                $model_inprocess->end_date = date("d/m/Y", strtotime($model_inprocess->end_date));
            }
            ?>
            <li class="col-sm-6">
                <?php echo $form->textField($model_inprocess, 'start_date', array('data-label' => 'Start Date', 'class' => 'datepicker', 'title' => 'Validate till Date', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo $form->textField($model_inprocess, 'end_date', array('data-label' => 'End Date', 'class' => 'datepicker', 'title' => 'End Date', 'onkeypress' => 'return false;')); ?>
            </li>
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default " id="inprocess_close" data-dismiss="modal">Close</button>
<?php
$url = Yii::app()->createUrl('/inprocess/saveEmployeeInprocess');

echo CHtml::ajaxsubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        if(data.status=="success"){  
            t8.success("Saved Successfully!");
            $("#inprocess_close").click();
            location.reload();
        } else { 
            $.each(data, function(key, val) {
                    t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
        $("#loader").show();
        $(".toast8-error").hide(); 
        $("#employeeinprocess-form .employeeinprocess-save-btn").prop("disabled", true);
        $("#employeeinprocess-form .employeeinprocess-save-btn").addClass("btn_loding").removeClass("btn-theme");
    }',
    'complete' => 'function(){
        $("#loader").hide();
        $("#employeeinprocess-form .employeeinprocess-save-btn").prop("disabled", false);
        $("#employeeinprocess-form .employeeinprocess-save-btn").addClass("btn-theme").removeClass("btn_loding");
    }'
), array('id' => 'mybtn' . rand(), 'class' => 'employeeinprocess-save-btn btn btn-theme'));
?>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("filldetails", "function filldetails(stage_id){ 
        var doc_id=$('#doc_id').val();
        var emp_id=$('#emp_id').val();
        jQuery.ajax({
            'dataType':'json',
            'data' : {'doc_id':doc_id,'emp_id':emp_id,'stage_id':stage_id},
            'type':'post',
            'url': '" . Yii::app()->createUrl('inprocess/getdetails') . "',
            'success': function(data) {
                $('#HrEmployeeInprocessDocument_start_date').addClass('filled');
                $('#HrEmployeeInprocessDocument_end_date').addClass('filled');
                $('#HrEmployeeInprocessDocument_start_date').val(data.start_date);
                $('#HrEmployeeInprocessDocument_end_date').val(data.end_date);
                $('#HrEmployeeInprocessDocument_id').val(data.id);
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
   
};", CClientScript::POS_HEAD);
?>

