<ul class="clearfix form-ul material">
    <li class="col-sm-4">
        <?php echo $form->hiddenField($model, 'id'); ?>  
        <?php echo $form->dropdownlist($model, 'course_id', HrMasTrainingCourse::getCoursedetail(),array('data-label'=>'Course <span style="color:red;">*</span>','empty'=>'Select','onchange'=>'gettrainingmodule(this.value);','data-search'=>true)); ?>
    </li>
    <li class="col-sm-4">
        <?php 
        $training_period=0;
        if($model->course_id>0){
            $training_period = HrMasTrainingCourse::model()->findByPK($model->course_id)->training_days; 
        }
        echo CHtml::textField('training_period',$training_period, array('class' => 'tooltipster', 'title' => 'Training Days', 'data-label' => 'Training Days','readonly'=>true)); ?>
    </li>
    <li class="col-sm-4" id="li_sub_course_id">
        <?php 
        $sub_course_arr=array();
        if($model->id>0){
            $sub_course_arr=HrMasTrainingCourseDetail::gettrainingCourse($model->course_id);
        }
        echo $form->dropdownlist($model, 'sub_course_id',$sub_course_arr,array('data-label'=>'Training Module <span style="color:red;">*</span>','empty'=>'Select','data-search'=>true)); ?>
    </li>
    <li class="col-sm-4">    
        <?php echo $form->textField($model, 'provider_name', array('class' => 'tooltipster', 'title' => 'Provider Name', 'data-label' => 'Provider Name <span style="color:red;">*</span>')); ?>    
    </li> 
    <li class="col-sm-4">
        <?php 
        $course_date = '';
        if($model->course_date!='' && $model->course_date!='0000-00-00'){
            $course_date=date("d/m/Y", strtotime($model->course_date));
        }
        echo $form->textField($model, 'course_date',array('data-label'=>'Course Date <span style="color:red;">*</span>','value' => $course_date,'class'=>'datepicker','onkeypress' => 'return false;')); ?>
    </li>  
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'location', array('class' => 'tooltipster', 'title' => 'Location', 'data-label' => 'Location ')); ?>    
    </li> 
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'fee_per_head', array('class' => 'tooltipster', 'title' => 'Fees/Head', 'data-label' => 'Fees/Head <span style="color:red;">*</span>')); ?>    
    </li> 
</ul>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("gettrainingmodule", "function gettrainingmodule(course_id) {    
    jQuery.ajax({
        'data' : {'course_id':course_id},
        'type':'post',
        'dataType':'json',
        'url': '" . Yii::app()->createUrl('hr/hrtraining/gettrainingmodule') . "',
        'cache': false,
        'success': function(data) {
            $('#training_period').addClass('filled');
            $('#training_period').val(data.training_days);
            $('#li_sub_course_id').html(data.drop);
        }, 
        'beforeSend':function(){
          $('#loader').show();    

        },
        'complete':function(){
            $('#btn_attendance_manager').show();
            $('#loader').hide();   
        }
    }); 
};", CClientScript::POS_HEAD);
?>