<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'overtimesheet-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_upload_overtimsheet = HrMasterUpload::model()->findByPK(25);
$upload_overtime_size =$model_upload_overtimsheet->max_upload_size * 1024 * 1024;
?>
<style>
    .bott_dec span{
        display: block;
        line-height: 20px;
        font-weight: normal;
        color: #4d4c4c;
        padding-left: 20px;
        letter-spacing: 0.25px;
    }
</style>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
             <li class="col-sm-3">
                    <?php 
                        $month =date("m");
                        $year =date("Y");
                        echo CHtml::dropDownList('overtime_month', $month,HrGenerelSettings::listMonths(), array('class' => 'tooltipster','data-label'=>'Month <span style="color : red;"> *</span>','empty'=>'Select'));
                    ?>
            </li>
            <li class="col-sm-3">
                    <?php 
                        echo CHtml::dropDownList('overtime_year',$year,HrGenerelSettings::listYears(0,1), array('class' => 'tooltipster','data-label'=>'Year <span style="color : red;"> *</span>','empty'=>'Select'));
                    ?>
            </li>
            <?php if($model_upload_overtimsheet->isActive=='Y') { ?>
            <li class="col-sm-3">
                <?php
                $allowedExtensions = array("csv");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => 'employeecsv_0_upload_csv',
                    'config' => array(
                        'action' => Yii::app()->createUrl('hr/'.Yii::app()->controller->id . '/UploadEmployeecsv', array('folder' => 'uploads/overtime')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => $upload_overtime_size,
                        'onStart' => "js:function(){}",
                        'class' => 'pull-right',
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            $('#overtime_upload_sheet').val(responseJSON.filename);
                }",
                )));
                echo CHtml::HiddenField('overtime_upload_sheet');
                ?>
            </li>
            <?php } ?>
            <li class="col-sm-3"><div id="csv_msg"></div></li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <span style="font-size:18px; color: red; float: left;"><b>* Upload files in .csv format *</b></span>
    <?php echo CHtml::link('<b>Download template</b>', array('hrtimesheet/DownloadSampleCsv'), array('target' => '_blank','class'=>"btn btn-theme")); ?>
    <button type="button" class="btn btn-danger" id="upload_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" id="<?php echo rand();?>" onclick="overtimeupload();">Save</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("overtimeupload", "function overtimeupload()
{
var month=$('#overtime_month').val();
var year=$('#overtime_year').val();
var filename=$('#overtime_upload_sheet').val();
    if(month != '' && year != '' && filename != ''){
        jQuery.ajax({
            'type': 'post',
            'dataType': 'json',
            'data': {
                month: month,year: year,filename: filename
            },
            'url'  : '" . Yii::app()->createUrl("hr/hrtimesheet/SaveUploadCsv") . "',
            'cache': false,
            'success': function (data) {
                if (data.status == 'success') {
                    $('#loader').hide();
                    if(data.error!=''){
                        $('#csv_msg').html(data.link);
                        $.each(data.error, function(key, val) {
                           t8.error(''+val+''); 
                        }); 
                    }else{
                        t8.success('Details Uploaded Successfully');	
                        $('#upload_close').click();	
                        reloadTable('#tbl_overtimesheet_details');
                        reloadTable('#table_overtime_upload');
                    }
                }
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
    }else{
        if(month== ''){
            t8.error('Select Month');
        }else if(year==''){
            t8.error('Select Year');
        }else{
            t8.error('File not found');
        }
    }   
}", CClientScript::POS_HEAD);
?>









