<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddata", 'function filterDataTable(){
        var branch_id= $("#overtime_branch_id").val();
        var month= $("#overtime_month_id").val();	
        var year= $("#overtime_year_id").val();	
        var table_id ="#table_overtime_upload";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
//            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 100,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrtimesheet/GetUploadOvertimeList') . '",
                type: "POST",
                "data" : {
                    "branch_id" : branch_id,"month" : month,"year" : year            
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,  
            order: [[ 2, "desc" ],[ 3, "desc" ]],
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        });
        $(".dataTables_scrollFoot").hide();
    }	
    $(document).ready(function() {  	 	
        filterDataTable();
         materializing(".material");   
    });', CClientScript::POS_HEAD);
$cs->registerScript("overtimedetails",  "function overtimedetails(){  
    $('#table_overtime_upload').DataTable().destroy();
    filterDataTable(); 
};", CClientScript::POS_HEAD);
$cs->registerScript("deleteovertimedetails", "function deleteovertimedetails(id) {
    if( confirm('Are you sure want to delete the overtime details ?') ){
        jQuery.ajax({
            'dataType':'json',
            'data': { 'id':id }  ,
            'type':'post',
            'url'  : $('#liveSite').val()+'index.php?r=hr/hrtimesheet/deleteovertimedetails',
            'cache': false,
            'success': function(data) {
                if( data.status == 'success' ){
                    t8.success('Deleted Successfully');
                    reloadTable('#table_overtime_upload');
                }else
                    t8.error('Error in Deleting Data');
            },
            'beforeSend':function(){
               $('#loader').show();                      
            },
            'complete':function(){
                $('#loader').hide();   
            }
        });
    }
};", CClientScript::POS_HEAD);

$model_upload_overtimsheet = HrMasterUpload::model()->findByPK(25);
  ?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[4].edit_upload !== 0) {
            items.Edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/hrtimesheet/edituploadovertime&branch="+datas[4].branch+'&month='+datas[4].month+'&year=' +datas[4].year, "Edit Upload Overtime Sheet ", "xl");
                }
            };
        }

        if (datas[4].delete_upload !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash",
                callback: function () {
                    deleteovertimedetails(datas[4].id);
                }
            };
        }
         if (datas[4].view_upload!== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/hrtimesheet/viewuploadovertimesheet&branch="+datas[4].branch+'&month='+datas[4].month+'&year=' +datas[4].year, "View Upload Overtime Sheet ", "lg");

                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #uploadovertimeindexdropdown .material-select-label {
        display: none;
    }
    </style>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
           Upload Overtime Sheet
            <div class="pull-right dis-flx">
            <div class="material col-sm-12 pd-zero" id="uploadovertimeindexdropdown">   
               
                <span class="col-sm-3 pull-right"> 
                  <?php echo CHtml::dropdownlist('overtime_year_id',date('Y'),HrGenerelSettings::listYears(4, 0),  array('empty' => 'Year','title' => 'Please Select Year','data-search'=>true,'onchange'=>'overtimedetails();','style'=>'width:100px;')); ?>                                                   
                </span>
                <span class="col-sm-3 pull-right"> 
                 <?php echo CHtml::dropdownlist('overtime_month_id',date('m'),HrGenerelSettings::listMonths(),  array('empty' => 'Month','title' => 'Please Select Month','data-search'=>true,'onchange'=>'overtimedetails();','style'=>'width:100px;')); ?>                                                   
                </span>
                <span class="col-sm-3 pull-right">       
                <?php echo CHtml::dropdownlist('overtime_branch_id','',MasCompanyBranchSponsor::getCompanyBranches(),  array('empty' => 'All Branches','title' => 'Please Select Branch','data-search'=>true,'onchange'=>'overtimedetails();','style'=>'width:150px;')); ?>                                                   
                </span>
                 </div>  
                <?php
                if($model_upload_overtimsheet->isActive=='Y'){
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_overtime_sheet_upload_menu'])  || Yii::app()->user->authorised_user == 1) { ?>
                        <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/hrtimesheet/Uploadtimesheet','Upload Overtime Sheet','xl')" title="Upload Overtime Sheet"><i class="fa fa-clock-o"></i> <i class="fa fa-upload"></i></button>  
                <?php } } ?>
                 <?php
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_overtime_sheet_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                     <a class="ad-btn" style="position: relative;top: 2px;" title="Add" onclick="loadPopupModal('hr/hrtimesheet/addovertime','Add Overtime Details','xl')" title="Add Overtime Details">                
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>  
                <?php } ?>
                
            <button class="btn btn-sm btn-theme" onclick="excelOverTimeSheetDetails()"  title="Download Overtime Sheet"><i class="fa fa-file-excel-o"></i></button>

        </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="table_overtime_upload" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Branch</th>
                            <th>Month</th>
                            <th>Year</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>

    <?php
   $cs = Yii::app()->getClientScript();
   $cs->registerScript("excelOverTimeSheetDetails", "
   function excelOverTimeSheetDetails() {
       var month = $('#overtime_month_id').val(); 
       var year = $('#overtime_year_id').val();  
       var branch = $('#overtime_branch_id').val(); 
       var errorMsg = '';
   
       if(month == '') {
           errorMsg += 'Please Select Month\\n';
       }
       if(year == '') {
           errorMsg += 'Please Select Year\\n';
       }
   
       if(errorMsg) {
           alert(errorMsg.trim());
       } else {
    
           window.open($('#liveSite').val() + 'index.php?r=hr/hrtimesheet/excelOverTimeSheetDetails&branch=' + branch + '&month=' + month + '&year=' + year, '_blank');     
       }
   }
   ", CClientScript::POS_HEAD);
   
    
    
    ?>