<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'add_overtimesheet-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php
                $month = date("m");
                $year = date("Y");
                echo CHtml::dropDownList('o_time_month', $month, HrGenerelSettings::listMonths(), array('class' => 'tooltipster', 'data-label' => 'Month <span style="color : red;"> *</span>', 'empty' => 'Select','data-search' => true));
                ?>
            </li>
            <li class="col-sm-3">
                <?php
                echo CHtml::dropDownList('o_time_year', $year, HrGenerelSettings::listYears(0, 1), array('class' => 'tooltipster', 'data-label' => 'Year <span style="color : red;"> *</span>', 'empty' => 'Select','data-search' => true));
                ?>
            </li>
        </ul>
        <div class="table-responsive">
            <table class="table table-hover table-bordered personal-task" id="tbl_add_ot_details">
                <tr>   
                    <th>No</th>
                    <th>Employee Name</th>
                    <th>Normal OT Hours</th>
                    <th>Weeekend OT Hours</th>
                    <th>Holiday OT Hours</th>
                    <th>Night OT Hours</th>
                    <th class="text-center">
                        <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#tbl_add_ot_details'));"><i class="fa fa-plus"></i></a></th>
                </tr>
                <tr>
                    <td><label>1</label>
                        <?php echo $form->hiddenField($model, '[0]id'); ?></td>
                    <td><?php echo $form->dropDownList($model, '[0]employee_id', Employee::getemployee(), array('class' => 'form-control', 'empty' => 'Select')); ?></td>
                    <td><?php echo $form->textField($model, '[0]normal_overtime', array('class' => 'form-control text-right', 'onkeypress' => 'return isPositiveNumber(event)')); ?></td>
                    <td><?php echo $form->textField($model, '[0]weekend_overtime', array('class' => 'form-control text-right', 'onkeypress' => 'return isPositiveNumber(event)')); ?></td>
                    <td><?php echo $form->textField($model, '[0]holiday_overtime', array('class' => 'form-control text-right', 'onkeypress' => 'return isPositiveNumber(event)')); ?></td>
                    <td><?php echo $form->textField($model, '[0]night_overtime', array('class' => 'form-control text-right', 'onkeypress' => 'return isPositiveNumber(event)')); ?></td>
                    <td class="text-center nw" width="1%" >
                        <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeTableRow($(\'#tbl_add_ot_details\'),this)', 'title' => 'Remove this item', 'id' => 'otdelete_0'));
                        ?>
                    </td>
                </tr>
            </table> 
        </div>  
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="ot_add_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme otadd-save-btn" id="<?php echo rand(); ?>" onclick="SaveOtDetails();">Save</button>
</div>
<?php
$this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("SaveOtDetails", "function SaveOtDetails() {
    jQuery.ajax({
        'dataType':'json',
        'data' : $('#add_overtimesheet-form').serialize(),
        'type':'post',
        'url': '" . Yii::app()->createUrl('hr/hrtimesheet/SaveOtDetails') . "',
        'cache': false,
        'success': function(data) {
            if(data.status=='success'){
                $('#ot_add_close').click(); 
                reloadTable('#table_overtime_upload');
                t8.success('Overtime Details Saved Successfully');
            }else{
                $.each(data, function(key, val) { 
                    t8.error(''+val+''); 
                }); 
            }
        },
        'beforeSend':function(){ 
            $('.toast8-error').hide(); 
            $('#add_overtimesheet-form .otadd-save-btn').prop('disabled', true);
            $('#add_overtimesheet-form .otadd-save-btn').addClass('btn_loding').removeClass('btn-theme');
            $('#loader').show();   
        },
        'complete':function(){
            $('#loader').hide();   
            $('#add_overtimesheet-form .otadd-save-btn').prop('disabled', false);
            $('#add_overtimesheet-form .otadd-save-btn').addClass('btn-theme').removeClass('btn_loding');
        }
    });
};", CClientScript::POS_HEAD);
?>
<script>
$(document).ready(function(){materializing(".material"); });
</script>