<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'saletarget-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
    <div class="tab-content">
        <div class="tab-pane active">
                   <ul class="clearfix form-ul material">
    			<li class="col-sm-3">
                            <?php echo $form->hiddenField($model, 'id'); ?>
                            <?php echo $form->dropDownList($model, 'branch_id',MasCompanyBranchSponsor::getCompanyBranches(),array('data-label'=>'Branch <span style="color : red;"> * </span>','empty'=>'Select','data-search'=>true)); ?>
                        </li>
                        <li class="col-sm-3">
                            <?php echo $form->dropDownList($model, 'department_id',MasDepartment::getDepartment(),array('data-label'=>'Department','empty'=>'Select','data-search'=>true)); ?>
                        </li>
                        <li class="col-sm-2">
                            <?php echo $form->dropDownList($model, 'month',HrGenerelSettings::listMonths1(),array('data-label'=>'Month <span style="color : red;"> * </span>','empty'=>'Select')); ?>
                        </li>
                        <li class="col-sm-2">
                            <?php echo $form->dropDownList($model, 'year',HrGenerelSettings::listYears(1,0),array('data-label'=>'Year <span style="color : red;"> * </span>','empty'=>'Select')); ?>
                        </li>
                        <li class="col-sm-2">
                            <?php echo $form->dropDownList($model, 'target_type', array('B'=>'Booking','C'=>'Card'),array('data-label'=>'Incentive Type <span style="color : red;"> * </span>','empty'=>'Select')); ?>
                        </li>
                        <li class="col-sm-2">
                            <button type="button" class="btn btn-theme " onclick="loademployeedetails();">Load</button>    
                        </li>
                    </ul>
            <div id="incentive_employee_details"></div>
            </div>
        </div>
<?php $this->endWidget();   
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", '$(document).ready(function() {
    var id  = $("#HrSaleTarget_id").val();
        if(id!=""){
            loademployeedetails();
        }
    });', CClientScript::POS_HEAD);
$cs->registerScript("loademployeedetails", "function loademployeedetails() {
        var branch  = $('#HrSaleTarget_branch_id').val();
        var department_id  = $('#HrSaleTarget_department_id').val();
        var month  = $('#HrSaleTarget_month').val();
        var year  = $('#HrSaleTarget_year').val();
        var target_type  = $('#HrSaleTarget_target_type').val();
        if(branch!='' && month!='' && year!='' && target_type!=''){
            jQuery.ajax({
                'data' : {'branch':branch,'department_id':department_id,'month':month,'year':year,'target_type':target_type},
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/hrsaletarget/loademployeedetails') . "',
                'cache': false,
                'success': function(data) {
                        $('#incentive_employee_details').html(data);
                }, 
                'beforeSend':function(){
                  $('#loader').show();                      
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });     
        }else{
            if(branch==''){
                t8.error('Select Branch');
            }else if(month==''){
                t8.error('Select month ');
            }else if(year==''){
                t8.error('Select year ');
            }else if(target_type==''){
                t8.error('Select Incentive Type ');
            }
        }
    };", CClientScript::POS_HEAD);
?>
<script>
$(document).ready(function(){materializing(".material"); });
</script>
