<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteExpense", "function deleteExpense(id){
    var r = confirm('Are you sure to send this?');
	
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType':'json',
              'data'  : 'id='+id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/hrrequest/deleteExpensedetails',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    t8.success('Deleted');
                    reloadTable('#tbl_expense_details'); 
                }else {
                    t8.error('error while deleting');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("loaddata", '
    function filterDataTable(employee_id,status,branch_id) {
        var table_id ="#tbl_expense_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            order: [[4, "desc"]],
            processing: true,
            columns: [            
                {className: "" },
                {className: ""},
                {className: ""},
                {className: "" },
                {className: ""},
                {className: ""},
                {className: "text-right"},
                {className: ""}, 
            ],
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrrequest/GetExpenseApprovalHR') . '",
                type: "POST",
                    "data" : {
                    "status" : status,"employee_id":employee_id,"branch_id":branch_id                  
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
	  $(document).ready(function() {  		  
        var status  = $("#expense_status").val();	
        var employee_id  = $("#expense_employee_id").val();
        var branch_id  = $("#expense_branch_id").val();
        filterDataTable(employee_id,status,branch_id);
         materializing(".material");
    })
	
	', CClientScript::POS_HEAD);

$cs->registerScript("expensedetails", "function expensedetails(){  
    $('#tbl_expense_details').DataTable().destroy();
    var status  = $('#expense_status').val();
    var employee_id  = $('#expense_employee_id').val();
    var branch_id       = $('#expense_branch_id').val();
    filterDataTable(employee_id,status,branch_id);
   
};", CClientScript::POS_HEAD);
    ?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[8].approve_reject !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/hrrequest/viewexpensehr&final_level="+ datas[8].final_level+'&level=' + datas[8].level_no +'&id=' + datas[8].id , "Confirm/Reject Expense Request", "xl");
                }
            };
        }
        if (datas[8].edit_expense !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/hrrequest/createemployeeexpense&branch=" + datas[8].branch + '&id='+datas[8].id, "Edit Expense Request", "xl");
                }
            };
        }
        if (datas[8].delete_expense !== 0) {
            items.Delete = {
                name: "Delete",
                icon: "fa-trash",
                callback: function () {
                     deleteExpense(datas[8].id);
                }
            };
        }
        if (datas[8].view_expense !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/hrrequest/viewexpensehrapproveview&id="+datas[8].id, "Expense Details", "xl");
                }
            };
        }
        
        if (datas[8].download_expense !== 0) {
            items.Download = {
                name: "Download",
                icon: "fa-download",
                callback: function () {
                      window.open($('#liveSite').val() + "/index.php?r=hr/hrreports/downloadDocument&id=" + datas[8].id, "_blank");
                }
            };
        }
        if (datas[8].print_expense !== 0) {
            items.Print = {
                name: "Print",
                icon: "fa-print",
                callback: function () {
                     window.open($('#liveSite').val() + "/index.php?r=hr/hrrequest/printexpensedetails&id=" + datas[8].en_id, "_blank");
                }
            };
        }
        if (datas[8].direct_approval !== 0) {
            items.directapprove = {
                name: "Direct Approval",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/hrrequest/viewexpensehr&final_level=Y&level="+ datas[8].last_level+'&id=' + datas[8].id , "Confirm/Reject Expense Request", "xl");
                }
            };
        }
        if (datas[8].approval_hierarcy !== 0) {
            items.approvehierarchy = {
                name: "Approve Hierarchy",
                icon: "fa-book",
                callback: function () {
                    loadPopupModal("hr/hrrequest/approvalhierarchy&function_type=7&employee_id="+ datas[8].employee_id , "Employee Hierarchy", "md");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
  <style>
    #mailsettingindexdropdown .material-select-label {
        display: none;
    }
    </style>  
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
          Expense Details
       <div class="pull-right dis-flx">
       <div class="material col-sm-12 pd-zero" id="mailsettingindexdropdown"> 
      
          <span class="col-sm-3 pull-right"> 
           <?php
                $dropdown_list=array();
                $model_approval_status=HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select'=>'max(max_level) as max_level','condition' =>'employeedetail.branch_or_sponsor_id="'.$branch.'" and functionality_id="7"'));
                if(empty($model_approval_status))
                $max_level=0;
                else
                $max_level=$model_approval_status->max_level;
                $selected='H';
                if($max_level<=1){
                    $dropdown_list=array(
                        0 => "Saved",
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=2){
                    $dropdown_list=array(
                        0 => "Saved",
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Confirmed",
                        5 => "Level 2 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=3){
                    $dropdown_list=array(
                        0 => "Saved",
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Confirmed",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Confirmed",
                        7 => "Level 3 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=4){
                    $dropdown_list=array(
                        0 => "Saved",
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Confirmed",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Confirmed",
                        7 => "Level 3 Rejected", 
                        8 => "Level 4 Confirmed",
                        9 => "Level 4 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=5){
                    $dropdown_list=array(
                        0 => "Saved",
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Confirmed",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Confirmed",
                        7 => "Level 3 Rejected", 
                        8 => "Level 4 Confirmed",
                        9 => "Level 4 Rejected", 
                        10 => "Level 5 Confirmed",
                        11 => "Level 5 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }
                $dropdown_list['H']='Waiting For HR Approval';
                $dropdown_list['14']='Payment Released';
            echo CHtml::dropdownlist('expense_status',$selected,$dropdown_list,array('title' => 'Please select Status','data-search'=>true,'multiple' => true,'onchange'=>'expensedetails()')); 
            ?>
            </span>
            <span class="col-sm-3 pull-right"> 
           <?php echo CHtml::dropDownList("expense_employee_id",'',Employee::getEmployee($branch), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'onchange'=>'expensedetails();')); ?>                           
          </span>
            </div>
            <input type="hidden" id="expense_branch_id" name="expense_branch_id" value="<?php echo  $branch; ?>"/>
            <?php
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_add'])  || Yii::app()->user->authorised_user == 1) {
                ?>
            <a class="ad-btn" title="Add" onclick="loadPopupModal('hr/hrrequest/createemployeeexpense&branch=<?php echo $branch; ?>', 'Add Expense', 'xl')">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
	</div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_expense_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Ref No</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Apply Date</th>
                            <th>Approval Date</th>
                            <th>Total</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
    </section>
