<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddata", '
    function filterDataTable(employee_id,status,branch_id) {
        var table_id ="#tbl_expense_verify_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            order: [[5, "desc"]],
            processing: true,
            columns: [            
                {className: "" },
                {className: ""},
                {className: ""},
                {className: "" },
                {className: ""},
                {className: ""},
                {className: "text-right"},
                {className: ""}, 
                {className: ""},
            ],
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrrequest/GetExpenseVerify') . '",
                type: "POST",
                    "data" : {
                    "status" : status,"employee_id":employee_id,"branch_id":branch_id                  
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
	  $(document).ready(function() {  		  
        var status  = $("#expense_status").val();	
        var employee_id  = $("#expense_employee_id").val();
        var branch_id  = $("#expense_branch_id").val();
        filterDataTable(employee_id,status,branch_id);
    })
	
	', CClientScript::POS_HEAD);

$cs->registerScript("expensedetails", "function expensedetails(){  
    $('#tbl_expense_verify_details').DataTable().destroy();
    var status  = $('#expense_status').val();
    var employee_id  = $('#expense_employee_id').val();
    var branch_id       = $('#expense_branch_id').val();
    filterDataTable(employee_id,status,branch_id);
   
};", CClientScript::POS_HEAD);
    ?>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            Expense Details
       <div class="pull-right">
           <?php echo CHtml::dropDownList("expense_employee_id",'',Employee::getEmployee($branch), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'class'=>'col-sm-3 form-control_1','onchange'=>'expensedetails();')); ?>                           
           <?php
                $dropdown_list=array(
                    12 => "Approved",
                );
                $dropdown_list['V']='Verify Pending';
                $dropdown_list['14']='Payment Released';
            echo CHtml::dropdownlist('expense_status','V',$dropdown_list,array('class'=>'col-sm-3 form-control_1','title' => 'Please select Status','onchange'=>'expensedetails()')); 
            ?>
            <input type="hidden" id="expense_branch_id" name="expense_branch_id" value="<?php echo  $branch; ?>"/>
	</div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_expense_verify_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Ref No</th>
                            <th>Employee Code</th>
                            <th>Employee Name</th>
                            <th>Apply Date</th>
                            <th>Approval Date</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
    </section>
