<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddata", '
        $(document).ready(function() {
        var table_id ="#tbl_employee_complaint_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrrequest/GetEmployeeComplaintList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
<script>
   
     function AddContextMenu(row, datas) { 
            let items = {};
                items.edit = {
                    name: "view",
                    icon: "fa-eye",
                    callback: function () {
                        loadPopupModal("hr/hrrequest/ViewComplaintRequest&id=" + datas[3].id, "Complaints/Suggestion", "lg");
                    }
                };
           
            if (Object.keys(items).length > 0) {
                $(row).contextMenu({
                    selector: 'td',
                    items: items
                });
            }
        }
     
</script>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">Complaints / Suggestions
            <div class="pull-right">
                <!-- <a class="btn btn-primary btn-md mt" data-toggle="modal" onclick="loadPopupModal('hr/hrrequest/CreateComplaint','Add Complaint/Suggestion');">Add<i class="icon-plus"></i></a> -->
                <a class="ad-btn" data-toggle="modal" onclick="loadPopupModal('hr/hrrequest/CreateComplaint','Add Complaint/Suggestion');" title="Add">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_employee_complaint_details" style="font-size: 12px">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Date</th>
                            <th>Complaint/Suggestion</th>                 
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
    </section>
