<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddata", 'function filterDataTable() {
        var table_id ="#tbl_resignation_approval_detail";
        var branch_id = $("#resignation_branch_id").val();
        var employee_id= $("#resignation_employee_id").val();	
        var status  = $("#resignation_status").val();
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrrequest/GetResignationApprovalHR') . '",
                type: "POST",
                "data" : {
                    "employee_id" : employee_id,"status" : status,"branch_id" : branch_id                
                },
                cache : false,
            },
            order: [[3, "DESC"]],
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  		
      filterDataTable();
       materializing(".material");   
    })
', CClientScript::POS_HEAD);
	
$cs->registerScript("resignationdetails",  "function resignationdetails(){  
    $('#tbl_resignation_approval_detail').DataTable().destroy();
    filterDataTable();
   
};", CClientScript::POS_HEAD); 
?>
 <style>
    #employeedocumentindexdropdown .material-select-label {
        display: none;
    }
    </style>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[8].approve_reject !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/hrrequest/viewresignationhrapprove&final_level="+ datas[8].final_level+'&level=' + datas[8].level_no +'&id=' + datas[8].id , "Confirm/Reject Resignation", "lg");
                }
            };
        }
       
        if (datas[8].view_details !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/hrrequest/viewresignation&id=" + datas[8].id, "Resignation Details", "lg");
                }
            };
        }
        
        if (datas[8].direct_approval !== 0) {
            items.directapproval = {
                name: "Direct Approval",
                icon: "fa-thumbs-o-up",
                callback: function () {
                    loadPopupModal("hr/hrrequest/viewresignationhrapprove&final_level=Y&level=" + datas[8].last_level+'&id='+datas[8].id, "Confirm/Reject Resignation", "lg");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">Resignation Request
        <div class="pull-right dis-flx">
      
            <input type="hidden" id="resignation_branch_id" name="resignation_branch_id" value="<?php echo  $branch; ?>"/>
            <div class="material col-sm-12 pd-zero" id="employeedocumentindexdropdown">   
          
    <span class="col-sm-3 pull-right">  
            <?php
                $dropdown_list=array();
                $model_approval_status=HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select'=>'max(max_level) as max_level','condition' =>'employeedetail.branch_or_sponsor_id="'.$branch.'" and functionality_id="5"'));
                 $max_level='';
                if(!empty($model_approval_status))
                {
                $max_level=$model_approval_status->max_level;
                }
                $selected='H';
                if($max_level<=1){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=2){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Confirmed",
                        5 => "Level 2 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=3){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Confirmed",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Confirmed",
                        7 => "Level 3 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=4){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Confirmed",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Confirmed",
                        7 => "Level 3 Rejected", 
                        8 => "Level 4 Confirmed",
                        9 => "Level 4 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }else if($max_level<=5){
                    $dropdown_list=array(
                        1 => "Applied",
                        2 => "Level 1 Confirmed",
                        3 => "Level 1 Rejected",
                        4 => "Level 2 Confirmed",
                        5 => "Level 2 Rejected", 
                        6 => "Level 3 Confirmed",
                        7 => "Level 3 Rejected", 
                        8 => "Level 4 Confirmed",
                        9 => "Level 4 Rejected", 
                        10 => "Level 5 Confirmed",
                        11 => "Level 5 Rejected", 
                        12 => "Approved",
                        13 => "Rejected"
                    );
                }
                $dropdown_list['H']='Waiting For HR Approval';
            echo CHtml::dropdownlist('resignation_status',$selected,$dropdown_list, array('title' => 'Expense Status','data-search'=>true,'multiple' => true, 'onchange' => 'resignationdetails();'));
            ?>	
            </span>
            <span class="col-sm-3 pull-right">  
            <?php echo CHtml::dropDownList("resignation_employee_id",'',EmployeeResignation::getEmployee(), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'onchange'=>'resignationdetails();')); ?>  
           </span>
            </div>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_resignation_request_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn"  onclick="loadPopupModal('hr/hrrequest/createresignationhr&branch=<?php echo $branch; ?>', 'Add Resignation', 'xl')">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_resignation_approval_detail" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Code</th>
                        <th>Employee Name</th>
                        <th>Apply Date</th>
                        <th>Approved Date</th>
                        <th>Last Working Day</th>
                        <th>Notice Period</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
