<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'create-complaint-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>

<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">     
            <li class="col-sm-4">
                <?php
                echo $form->dropDownList($model,'employee_id', Employee::getemployee(), array('empty' => 'Select', 'data-label' => 'Employee Name','data-search'=>'true'));
                ?>  
            </li>
            <li class="col-sm-8">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textArea($model, 'complaint_suggestion', array('data-label' => 'Complaint/Suggestion  <span style="color : red;">*</span>')); ?>
            </li>
        </ul>

    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="complaint_form_close" data-dismiss="modal">Close</button>
<?php
$url = Yii::app()->createUrl('hr/hrrequest/saveComplaintSuggestion');
echo CHtml::ajaxsubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
             t8.success("Saved Successfully!");
             $("#complaint_form_close").click();
             reloadTable("#tbl_hr_complaint_details");
        } else {           
            $.each(data, function(key, val) { 
                    t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
        $("#loader").show();
        $(".toast8-error").hide(); 
        $("#create-complaint-form .suggestion-btn").prop("disabled", true);
        $("#create-complaint-form .suggestion-btn").addClass("btn_loding").removeClass("btn-theme");
    }',
    'complete' => 'function(){ 
        $("#loader").hide();
        $("#create-complaint-form .suggestion-btn").prop("disabled", false);
        $("#create-complaint-form .suggestion-btn").addClass("btn-theme").removeClass("btn_loding");
    }'
), array('id' => 'mybtn' . rand(), 'class' => 'suggestion-btn btn btn-theme'));
?>
</div>
<?php $this->endWidget(); ?>








