<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'create-expense-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_upload_expense = HrMasterUpload::model()->findByPK(28);
$upload_expense_size = $model_upload_expense->max_upload_size * 1024 * 1024;
echo CHtml::hiddenField("document_upload_expense", $model_upload_expense->isActive);
echo CHtml::hiddenField("document_upload_expense_size", $model_upload_expense->max_upload_size);

?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php
                echo $form->hiddenField($model, 'id');
                echo $form->hiddenField($model, 'total');
                echo $form->hiddenField($model, 'status');
                echo $form->hiddenField($model, "function_type");
                echo $form->hiddenField($model, "last_approved_level");
                echo $form->dropDownList($model, 'employee_id', Employee::getemployee($branch), array('empty' => 'Select', 'data-label' => 'Employee Name', 'data-search' => 'true', 'onchange' => 'getemployeedetails(this.value);'));
                ?>  
            </li>
        </ul>
        <div class="table-responsive">
            <table class="table table-hover table-bordered personal-task" id="add_expense_table">
                <tr>
                    <th style="width: 2%">No</th>
                    <th style="width: 10%">Date</th>
                    <th style="width: 15%">Particulars</th>
                    <th style="width: 8%">Currency</th>
                    <th style="width: 3%">Ex.Rate</th>
                    <th style="width: 8%">Amount</th>
                    <th style="width: 8%">Net Amount</th>
                    <th style="width: 25%">Notes</th>
                    <?php if($model_upload_expense->isActive=="Y"){?>
                    <th style="width: 5%">Files</th>
                    <th style="width: 5%">Upload</th>
                    <?php } ?>
                    <th class="text-center" style="width: 2%">
                        <a class="btn btn-sm btn-theme" href="javascript:void(0);" onclick="addExpenseTableRow1($('#add_expense_table'));"><i class="fa fa-plus"></i></a>
                    </th>
                </tr>
                <?php
                foreach ($model_details as $i => $each_details):
                    ?>
                    <tr>
                        <td><label><?php echo ($i + 1); ?></label>
                        <td>
                            <?php echo $form->hiddenField($each_details, "[" . $i . "]id"); ?>
                            <?php
                            if ($each_details->expense_date != '' && $each_details->expense_date != '0000-00-00') {
                                $each_details->expense_date = date("d/m/Y", strtotime($each_details->expense_date));
                            }
                            if (empty($model->id)) {
                                $each_details->expense_date = date('d-m-y');
                            }

                            echo $form->textField($each_details, "[" . $i . "]expense_date", array('class' => 'form-control datepicker', 'style' => 'text-align:left'));
                            ?>
                        </td>
                        <td>
                            <?php echo $form->dropDownList($each_details, "[" . $i . "]expense_component_id", HrMasEmployeeExpense::getexpense(), array('class' => 'form-control', 'empty' => 'Select', 'data-label' => 'Expense', 'data-search' =>true)); ?>

                        </td>
                        <td>
                            <?php
                            if (empty($model->id)) {
                                $each_details->currency_id = 1;
                            }
                            ?>
                            <?php echo $form->dropDownList($each_details, "[" . $i . "]currency_id", MasCurrency::getCurrency(), array('class' => 'form-control', 'onChange' => 'getcurrencyrate(this.id)','empty' => 'Select', 'data-label' => 'Expense', 'data-search' =>true)); ?>

                        </td>
                        <td>
                             <?php  if($model->id == 0){
                            if($each_details->currency_id > 0){
                                $each_details->exchange_rate  = $each_details->currencydetail->exchange_rate;
                                }
                            } ?>

                            <?php echo $form->textField($each_details, "[" . $i . "]exchange_rate", array('class' => 'form-control', 'onkeyup' => 'calculateValue($("#add_expense_table"),this.id);', 'onkeypress' => 'return isNumberKey(event,this.value); ')); ?>
                        </td>
                        <td>
                            <?php echo $form->textField($each_details, "[" . $i . "]amount", array('class' => 'form-control', 'onkeyup' => 'calculateValue($("#add_expense_table"),this.id);', 'onkeypress' => 'return isNumberKey(event,this.value); ', 'style' => 'text-align:right')); ?>
                        </td>
                        <td>
                            <?php echo $form->textField($each_details, "[" . $i . "]grand_total", array('class' => 'form-control', 'style' => 'text-align:right')); ?>
                        </td>
                        <td>
                            <?php echo $form->textField($each_details, "[" . $i . "]notes", array('class' => 'form-control','style' => "height:35px; width:350px;",
                        'onfocus' => 'this.style.height = "100px"; this.style.width = "350px";', 'onblur' => 'this.style.height = "35px";this.style.width = "350px";')); ?>
                        </td>
                        <?php if($model_upload_expense->isActive=="Y"){ ?>
                        <td>
                            <div id="divfile_<?php echo $i; ?>">
                                <span id="spanfile_<?php echo $i; ?>">
                                    <?php
                                    if ($each_details->file != ''):
                                        $document_file_array = explode(',', $each_details->file);
                                        foreach ($document_file_array as $value_file) {
                                            echo $value_file;
                                            echo '&nbsp;';
                                            ?>
                                            <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deleteuploadedfile(<?php echo $i ?>,<?php echo $each_details->id ?>, '<?php echo $value_file ?>');"><i class="fa fa-trash"></i></a>
                                            <?php
                                            echo '<br>';
                                        }
                                    endif;
                                    ?>
                                </span>
                                <?php echo $form->hiddenField($each_details, "[" . $i . "]file"); ?>
                            </div>
                        </td>
                        <td>
                            <?php
                            $allowedExtensions = array("csv", "zip", "png", "txt", "pdf", "doc", "docx", "jpg", "jpeg", "gif");
                            $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                                'id' => 'EmployeeExpenseDetails_' . $i . '_uploadfile',
                                'config' => array(
                                    'action' => Yii::app()->createUrl('hr/' . Yii::app()->controller->id . '/UploadExpense', array('folder' => 'uploads/expense')),
                                    'multiple' => true,
                                    'allowedExtensions' => $allowedExtensions,
                                    'sizeLimit' => $upload_expense_size,
                                    'onStart' => "js:function(){}",
                                    'onSubmit' => "js:function(){
                                        $('.toast8-error').hide(); 
                                        var employee_id =$('#EmployeeExpense_employee_id').val();
                                        var expense_date =$('#EmployeeExpenseDetails_" . $i . "_expense_date').val();
                                        var component_id =$('#EmployeeExpenseDetails_" . $i . "_expense_component_id').val();
                                        var amount =$('#EmployeeExpenseDetails_" . $i . "_amount').val();
                                        if(employee_id==''){
                                            t8.error('Please Select Employee');
                                            return false;
                                        }else if(expense_date==''){
                                            t8.error('Please Select Date');
                                            return false;
                                        }else if(component_id==''){
                                            t8.error('Please Select Component');
                                            return false;
                                        }else if(amount==''){
                                            t8.error('Please Enter Amount Details');
                                            return false;
                                        }
                                        this.params = { employee_id: employee_id,expense_date: expense_date,component: component_id,amount: amount,}
                                    }",
                                    'class' => 'pull-right',
                                    'onComplete' => "js:function(id, fileName, responseJSON){
                                        //$('#EmployeeExpenseDetails_" . $i . "_file').val(responseJSON.filename);
                                             var val_doc =$('#EmployeeExpenseDetails_" . $i . "_file').val();
                                    if(val_doc!=''){
                                        $('#EmployeeExpenseDetails_" . $i . "_file').val(val_doc+','+responseJSON.filename); 
                                    }else{
                                    $('#EmployeeExpenseDetails_" . $i . "_file').val(responseJSON.filename); 
                                    }
                                   
                }",
                            )));
                            ?>


                        </td>
                        <?php } ?>
                        <td class="text-center nw" width="1%">
                            <?php if($model_upload_expense->isActive=="Y"){ ?>
                            <div id="divdownload_<?php echo $i; ?>">
                                <?php 
                                if($each_details->file!=''): 
                                    echo CHtml::link('<i class="fa fa-download"></i>',array('hrrequest/downloadDocument/&id='.$each_details->id),array('class'=>'btn btn-xs btn-warning','title'=>'Download'));
                                    $arr_doc_val = explode(',', $each_details->file);
                                    if (count($arr_doc_val)==1) {
                                ?>
                                    <a href="<?php echo Yii::app()->baseUrl. "/uploads/expense/" . $each_details->file; ?>" target="_blank" class="btn btn-xs btn-warning" title="View Uploaded File"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                <?php
                                    }
                                endif;
                                ?>
                            </div>
                            <?php } ?>
                            <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('id' => "EmployeeExpenseDetails_" . $i, 'class' => 'btn btn-sm btn-danger', 'onclick' => 'removeExpense($(\'#add_expense_table\'),this,this.id)', 'title' => 'Remove this Row')); ?>
                        </td>

                    </tr>
                <?php endforeach; ?>
            </table>
            <table class="table table-hover table-bordered personal-task">
                <tr>
                    <th colspan="4"><b>Total Amount</b></th>                        
                    <th colspan="3"><div id="total_amount"><?php echo $model->total; ?></div></th>

                </tr>
            </table>
            <input type="hidden" id="flag_status" name="flag_status" value=""/>
            <input type="hidden" id="button_status" name="button_status" value="0"/>
        </div>
    </div>
</div>
<div class="modal-footer">
    <div class="color-indicator pull-left">
        <span style="display: inline-block;width:30px;height:30px; box-shadow: 0px 2px 10px 2px #b7b5b5; background-color: #f6bdb1"></span><span class="verti"><b> Entry exist in other expense detail</b></span>
    </div>
    <button type="button" class="btn btn-danger" id="expense_form_close" data-dismiss="modal">Close</button>
    <?php
    if($model->status=='' || $model->status==0){
    ?>
    <button type="button" class="btn btn-warning" onclick="checkduplicateentry(1);">Save</button>
    <?php } ?>
    <button type="button" class="btn btn-success" onclick="checkduplicateentry(2);">Submit</button>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("addExpenseTableRow1", "function addExpenseTableRow1(jQtable) {
    var newrow= jQtable.find('tr:last').clone();
    var lastId = jQtable.find('tr:last td>input').attr('id');
    var thenum = lastId.match(/\d+/g);
    var newId = Number(thenum) + 1;
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
    var yyyy = today.getFullYear();
    today = dd + '/' + mm + '/' + yyyy;
    var newrow= jQtable.find('tr:last').clone();
    newrow.find('label').html(newId+1);
    newrow.find('a,input,textarea,label,checkbox,select,div,span,.errorMessage').each(function() { 
                    this.id= this.id.replace(/\d+/,newId); 
                   if(!$(this).is(':checkbox'))
                        this.value  = ''; 
                    else
                        $(this).prop('checked', false);
                    (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : '';
    });
    jQtable.append(newrow);
     var document_upload_expense = $('#document_upload_expense').val();  
    var document_upload_expense_size = $('#document_upload_expense_size').val();  
    if(document_upload_expense=='Y'){
    var uploader = new qq.FileUploader({
        element: document.getElementById('EmployeeExpenseDetails_'+newId+'_uploadfile'),
        params: { field_id: 'EmployeeExpenseDetails_'+newId+'_file' },
        action : '" . Yii::app()->createUrl('hr/' . Yii::app()->controller->id . '/UploadExpense', array('folder' => 'uploads/expense')) . "',
        allowedExtensions: ['csv', 'zip', 'png', 'txt', 'pdf', 'doc', 'docx', 'jpg', 'jpeg', 'gif'],
        sizeLimit : document_upload_expense_size * 1024 * 1024,
        multiple : true,
        onSubmit :function(){
            $('.toast8-error').hide(); 
            var employee_id =$('#EmployeeExpense_employee_id').val();
            var expense_date =$('#EmployeeExpenseDetails_'+newId+'_expense_date').val();
            var component_id =$('#EmployeeExpenseDetails_'+newId+'_expense_component_id').val();
            var amount =$('#EmployeeExpenseDetails_'+newId+'_amount').val();
            if(employee_id==''){
                t8.error('Please Select Employee');
                return false;
            }else if(expense_date==''){
                t8.error('Please Select Date');
                return false;
            }else if(component_id==''){
                t8.error('Please Select Component');
                return false;
            }else if(amount==''){
                t8.error('Please Enter Amount Details');
                return false;
            }
            this.params = { employee_id: employee_id,expense_date: expense_date,component: component_id,amount: amount,}
        },
        onComplete: function(id, fileName, responseJSON){
            var field_name = responseJSON.field_id;
            var file_name=responseJSON.filename;
            var val_doc = $('#EmployeeExpenseDetails_'+newId+'_file').val();
             if(val_doc!='')
             {
             $('#EmployeeExpenseDetails_'+newId+'_file').val(val_doc+','+responseJSON.filename); 
             }
             else
             {
             $('#EmployeeExpenseDetails_'+newId+'_file').val(responseJSON.filename); 
             }
        },
    });
    }
    $('#EmployeeExpenseDetails_'+newId+'_expense_date').datetimepicker({format: 'DD/MM/YYYY'}).val(today);
    $('#EmployeeExpenseDetails_'+newId+'_currency_id').val(1);
    $('#EmployeeExpenseDetails_'+newId+'_exchange_rate').val(1);
    $('#spanfile_'+newId+'').html('');
    $('#divdownload_'+newId+'').html('');
}", CClientScript::POS_HEAD);
$cs->registerScript("removeExpense", "function removeExpense(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var id=$('#EmployeeExpenseDetails_'+row_field+'_id').val();
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        var tr  =   $(evt).parent().parent();
        if(isRowEmpty(tr)) {
            if(id!=''){
                jQuery.ajax({
                    'type': 'post',
                    'dataType': 'json',
                    'url': '" . Yii::app()->createUrl('hr/hrrequest/deleteExpense') . "',
                    'data': {'id':id}  ,
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            $(evt).parents('tr').remove();
                            var i=0;
                            jQtable.find('tr:gt(0)').each(function() {
                                $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                {
                                    old_id   =   $(this).attr('id');
                                    if(old_id!==undefined) {
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                    }
                                    old_name =   $(this).attr('name');
                                    if(old_name!==undefined) {
                                        new_name =   old_name.replace(/\d+/,i);
                                        $(this).attr('name',new_name);
                                    }
                                });
                                $(this).find('td:first label').html(++i);
                            });
                            t8.success('Expense Deleted');
                            calculateValue($('#add_expense_table'));
                            reloadTable('#tbl_expense_details');
                        }else{
                            t8.error('Deletion Not Possible');
                        }
                    }
                });
            }else{
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() {
                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        if(old_id!==undefined) {
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                        }
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
                calculateValue($('#add_expense_table'));
            }
            $('#expensedetaildelete_'+row_field+'').click();
        }
    }else {
        alert('Atleast one item needed here');
    }
    
};", CClientScript::POS_HEAD);
$cs->registerScript("checkTotal", "function checkTotal() {
    var num_rows=$('#add_expense_table').find('tr:gt(0)').length;
    var total_amount=0.00;
    for(i=0;i<num_rows;i++){
        var cost_item=$('#EmployeeExpenseDetails_'+i+'_amount').val(); 
         var rate=$('#EmployeeExpenseDetails_'+i+'_exchange_rate').val(); 
        if(parseFloat(cost_item)>0){
            total_amount+=parseFloat(cost_item)*parseFloat(rate);
            $('#total_amount').html(parseFloat(total_amount).toFixed(2)); 
            $('#EmployeeExpense_total').val(parseFloat(total_amount).toFixed(2));
        }
    }
};", CClientScript::POS_HEAD);

$cs->registerScript("converttofloat", " function converttofloat(field_id) { 
    var field_id=field_id.split('_');
    var i=field_id[1]; 
    var total_cost = $('#EmployeeExpenseDetails_'+i+'_amount').val();        
    $('#EmployeeExpenseDetails_'+i+'_amount').val(Math.round(total_cost));

 }", CClientScript::POS_HEAD);
$cs->registerScript('SaveExpensedetails', 'function SaveExpensedetails(){	
        jConfirm("Need Approval from Other Department?", "Confirmation Dialog", function(r) {
            if (r == true) {
                $("#EmployeeExpense_status").val(1);
                $("#EmployeeExpense_last_approved_level").val(0);
                SaveEmployeeExpense();
            }else{
                $("#EmployeeExpense_status").val(12);
                SaveEmployeeExpense();
            }
        }); 
};', CClientScript::POS_HEAD);
$cs->registerScript('SaveEmployeeExpense', 'function SaveEmployeeExpense(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#create-expense-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('hr/hrrequest/SaveExpenseDetails') . '",
        "success":function(data){
            if(data.status=="success"){  
                t8.success(data.msg);
                $("#expense_form_close").click();
                reloadTable("#tbl_expense_details");
            } else { 
               $.each(data, function(key, val) {
                       t8.error(""+val+""); 
               }); 
            } 
        },
        "beforeSend":function(){
            $("#loader").show();
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
$cs->registerScript("getemployeedetails", "function getemployeedetails(id) {
         jQuery.ajax({
                   'dataType':'json',
                    'data': {'id':id}  ,
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('hr/hrrequest/getemployeedetails') . "',
                    'cache': false,
                     'success': function(data) {
                      $('#EmployeeExpense_function_type').val(data.functiontype);
                      $('#EmployeeExpense_last_approved_level').val(data.maxlevel);
                    },
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();
                    }
        });
    };", CClientScript::POS_HEAD);
$cs->registerScript("getcurrencyrate", "
    
    function getcurrencyrate(id){
        var currency_id = $('#'+id).val();
        var arr_fields= id.split('_');
        var inc = id.split('_')[1];
        var row_field = arr_fields[1];
        jQuery.ajax({
          'dataType'  : 'json',
          'type'  : 'post',
          'data'  : 'currency_id=' + currency_id,
          'url'  : $('#liveSite').val()+'index.php?r=hr/hrrequest/getExchangeRate',
          'cache': false,
          'success':function(data){
        
           $('#EmployeeExpenseDetails_'+row_field+'_exchange_rate').val(data.drop).addClass('filled');
            calculateValue($('#add_expense_table'));
           }
        });
            
    
    }", CClientScript::POS_HEAD);

$cs->registerScript("calculateValue", " function calculateValue(jQtable,id,frm) {
   
        formIdStarter =   jQtable.attr('id').split(/_(.+)?/)[0];
        var amount,ex_rate,net;       
        var total_amount= 0;
        var grand_total =   0;
        var cnt=0;
        jQtable.find('tr:gt(0)').each(function() {
            var model_id=this.id;
            var arr_fields= model_id.split('_');
            var row_field=arr_fields[1];
            net = 0;
            amount =   $(this).find('[id $=_amount]').val();
            ex_rate =   $(this).find('[id $=_exchange_rate]').val();
            total_amount  =   (Number(amount)*Number(ex_rate)).toFixed(2);
                    
        	
    		    
               $(this).find('[id $=_grand_total]').val(Number(total_amount).toFixed(2));
                grand_total +=   Number(total_amount);
                 cnt++;
        	 });
        
        $('#total_amount').html(parseFloat(grand_total).toFixed(2)); 
        $('#EmployeeExpense_total').val(parseFloat(grand_total).toFixed(2));
       
        return false;	
        		
        }", CClientScript::POS_HEAD);
$cs->registerScript("deleteuploadedfile", "function deleteuploadedfile(field_id,doc_id,file_name) {
    var row_field= field_id;  
    jQuery.ajax({
        //'dataType':'json',
         'data': {'id':doc_id,'row_field':row_field,'file_name':file_name}  ,
        'type':'post',
        'url': '" . Yii::app()->createUrl('hr/hrrequest/deleteuploadedfile') . "',
        'cache': false,
        'success': function(data) {     
            $('#divfile_'+row_field+'').html(data); 
        },
        'beforeSend':function(){
            $('#loader').show();
        },
        'complete':function(){
            $('#loader').hide();
        }
    });
};", CClientScript::POS_HEAD);
$cs->registerScript("checkduplicateentry", "function checkduplicateentry(button_status_val) {
    $('#flag_status').val(0);
    $('#button_status').val(button_status_val);
    var num_rows=$('#add_expense_table').find('tr:gt(0)').length;
    var total_amount=0.00;
    var total_rows=num_rows;
    var row_dec=0;
    for(i=0;i<num_rows;i++){
        var expense_date=$('#EmployeeExpenseDetails_'+i+'_expense_date').val();  
        var component_id=$('#EmployeeExpenseDetails_'+i+'_expense_component_id').val();  
        var currency_id=$('#EmployeeExpenseDetails_'+i+'_currency_id').val();  
        var grand_total=$('#EmployeeExpenseDetails_'+i+'_grand_total').val();
        var employee_id=$('#EmployeeExpense_employee_id').val();
        var id=$('#EmployeeExpenseDetails_'+i+'_id').val();
        jQuery.ajax({
            'dataType':'json',
             'data': {'component_id':component_id,'currency_id':currency_id,'grand_total':grand_total,'expense_date':expense_date,'id':id,'row_num':i,'employee_id':employee_id}  ,
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/hrrequest/checkduplicateexpense') . "',
            'cache': false,
            'success': function(data) {   
                if(data.exist==1){
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_expense_date').style.backgroundColor ='#f6bdb1' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_expense_component_id').style.backgroundColor ='#f6bdb1' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_currency_id').style.backgroundColor ='#f6bdb1' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_exchange_rate').style.backgroundColor ='#f6bdb1' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_amount').style.backgroundColor ='#f6bdb1' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_grand_total').style.backgroundColor ='#f6bdb1' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_notes').style.backgroundColor ='#f6bdb1' 
                    $('#flag_status').val(1);
                }else{
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_expense_date').style.backgroundColor ='' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_expense_component_id').style.backgroundColor ='' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_currency_id').style.backgroundColor ='' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_exchange_rate').style.backgroundColor ='' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_amount').style.backgroundColor ='' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_grand_total').style.backgroundColor ='' 
                    document.getElementById('EmployeeExpenseDetails_'+data.row_number+'_notes').style.backgroundColor ='' 
                }
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
                row_dec++;
                showalert(total_rows,row_dec);
            }
        });
    }
};", CClientScript::POS_HEAD);
$cs->registerScript('showalert', 'function showalert(total_rows,row_dec){	
        if(total_rows==row_dec){
            var flag_status=$("#flag_status").val();
            if(flag_status==1){
                SaveDuplicateExpense();
            }else if(flag_status==0){
                SaveExpense();
            }
        }
};', CClientScript::POS_HEAD);
$cs->registerScript('SaveExpense', 'function SaveExpense(){	
    var button_status_val=$("#button_status").val();
    var msg="Confirm Save ?";
        if(button_status_val==1){
            msg="Confirm Save ?";
        }else if(button_status_val==2){
            msg="Confirm Submit ?";
        }
        jConfirm(""+msg+"", "Confirmation Dialog", function(r) {
            if (r == true) {
                $("#flag_status").val(0);
                if(button_status_val==1){
                    $("#EmployeeExpense_status").val(0);
                    $("#EmployeeExpense_last_approved_level").val(0);
                    SaveEmployeeExpense();
                }else if(button_status_val==2){
                    SaveExpensedetails();
                }
            }else{
                $("#flag_status").val(0);
            }
        }); 
};', CClientScript::POS_HEAD);
$cs->registerScript('SaveDuplicateExpense', 'function SaveDuplicateExpense(){	
    var button_status_val=$("#button_status").val();
    var msg="Confirm Save ?";
        if(button_status_val==1){
            msg="Confirm Save ?";
        }else if(button_status_val==2){
            msg="Confirm Submit ?";
        }
        jConfirm(""+msg+"", "Confirmation Dialog", function(r) {
            if (r == true) {
                $("#flag_status").val(0);
                if(button_status_val==1){
                    $("#EmployeeExpense_status").val(0);
                    $("#EmployeeExpense_last_approved_level").val(0);
                    SaveEmployeeExpense();
                }else if(button_status_val==2){
                    SaveExpensedetails();
                }
            }else{
                $("#flag_status").val(0);
            }
        }); 
};', CClientScript::POS_HEAD);
?>