<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("certificatedetails", "function certificatedetails(){
    $('#tbl_certificateapproval_details').DataTable().destroy();
        var type       = $('#certificate_type').val();
        filterDataTable(type);
};", CClientScript::POS_HEAD);

$cs->registerScript("filterDataTable", 'function filterDataTable(type){
        var table_id ="#tbl_certificateapproval_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrrequest/GetPendingRequest') . '",
                type: "POST",
                "data" : {
                    "type" : type,
                    "status": $("#certificate_status").val(),
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();

	}
    $(document).ready(function() {
        var type= $("#certificate_type").val();
        filterDataTable(type);
    });', CClientScript::POS_HEAD);
?>
<script>
         function AddContextMenu(row, datas) { 
                let items = {};
                if (datas[5].approve_reject !== 0) {
                    items.approve = {
                        name: "Approve",
                        icon: "fa-thumbs-up",
                        callback: function () {
                            loadPopupModal("hr/hrrequest/certificateapprove&final_level=" + datas[5].final_level+'&level='+datas[5].level_no+'&id='+datas[5].id, 'Confirm/Reject Certificate', "lg");
                    }
                    };
                }
                    items.view = {
                        name: "view",
                        icon: "fa-eye",
                        callback: function () {
                             loadPopupModal("hr/hrrequest/view&id=" + datas[5].id, 'CERTIFICATE APPLICATION DETAILS', "lg");
                    }
                    };
                

               if (Object.keys(items).length > 0) {
                   $(row).contextMenu({
                       selector: 'td',
                       items: items
                   });
               }
           }

    </script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-thumbs-up"></i> -->
         Certificate Approve/Cancel
        <div class="pull-right" style="display: flex;">
<?php echo CHtml::dropdownlist('certificate_type','',MasCertificate::getCertificateName(), array('class' => 'form-control input-md', 'onchange' => 'certificatedetails();','empty'=>'All Certificates')); ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_certificateapproval_details" style="font-size: 12px">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Employee</th>
                        <th>Certificate Name</th>
                        <th>Apply Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
               
            </table>
        </div>
    </div>
</section>
