<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'apply-resignation-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo $form->hiddenField($model, 'id');
                echo $form->hiddenField($model, 'status');
                echo $form->hiddenField($model,"function_type"); 
                echo $form->hiddenField($model,"last_approved_level");
                ?>
                <?php
                echo $form->dropDownList($model, 'employee_id', Employee::getemployee($branch), array('empty' => 'Select', 'data-label' => 'Employee Name', 'data-search' => 'true','onchange'=>'getemployeedetail(this.value);'));
                ?>
            </li>
            <li class="col-sm-3">			
                <?php echo $form->dropDownList($model, 'notice_type', MasNoticeperiod::getNoticeperiod(), array('data-label' => 'Notice Period <span style="color : red;"> * </span>', 'prompt' => 'Select', 'data-search' =>true)); ?>
            </li>
<!--            <li class="col-sm-4">
                <?php
                /*if ($model->last_date != '' && $model->last_date != '0000-00-00') {
                    $last_date = date("d/m/Y", strtotime($model->last_date));
                } else {
                    $last_date = date("d/m/Y");
                }
                echo $form->textField($model, 'last_date', array('data-label' => 'Last Working Date', 'value' => $last_date, 'readonly' => true));*/
                ?>
            </li>-->
            <li class="col-sm-5">
                <?php
                $reason = '';
                if ($model->reason != '') {
                    $reason = $model->reason;
                }
                echo $form->textArea($model, 'reason', array('data-label' => 'Reason For Resignation <span style="color : red;">*</span>', 'value' => $reason));
                ?>
            </li>
        </ul>
    </div>
</div>

<div class="modal-footer">

    <button type="button" class="btn btn-danger" id="apply_form_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" id="btn_apply_r_1" onclick="SaveHRresignation();">Save</button>




</div>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript('SaveHRresignation', 'function SaveHRresignation(){	
        jConfirm("Need Approval from other department?", "Confirmation Dialog", function(r) {
            if (r == true) {
                $("#EmployeeResignation_status").val(1);
                $("#EmployeeResignation_last_approved_level").val(0);
                Saveresignation();
            }else{
                $("#EmployeeResignation_status").val(12);               
                Saveresignation();
            }
        }); 
};', CClientScript::POS_HEAD);
$cs->registerScript('Saveresignation', 'function Saveresignation(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#apply-resignation-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('hr/hrrequest/SaveApplyHRResignation') . '",
        "success":function(data){
            if(data.status=="success"){  
                t8.success("Details Saved Successfully!");
                $("#apply_form_close").click();
                reloadTable("#tbl_resignation_approval_details");
                reloadTable("#tbl_resignation_approval_detail");
            } else { 
               $.each(data, function(key, val) {
                       t8.error(""+val+""); 
               }); 
            } 
        },
        "beforeSend":function(){
            $("#loader").show();
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
$cs->registerScript("getemployeedetail", "function getemployeedetail(id) {
         jQuery.ajax({
                   'dataType':'json',
                    'data': {'id':id}  ,
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('hr/hrrequest/getemployeedetail') . "',
                    'cache': false,
                     'success': function(data) {
                      $('#EmployeeResignation_function_type').val(data.functiontype);
                      $('#EmployeeResignation_last_approved_level').val(data.maxlevel);
                    },
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();
                    }
        });
    };", CClientScript::POS_HEAD);
?>

<?php $this->endWidget(); ?>



