<?php
if($sort==''){
    $sort=1;
}
?>
<div class="out_border">
    <div class="row">
        <div class="col-md-12">
             <ul class="clearfix form-ul material"> 
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_asset_branch_id',$branch_id,MasCompanyBranchSponsor::getCompanyBranches(),array('data-label'=>'Branch','empty'=>'All','data-search'=>true,'onchange'=>'getbranchemployee();'));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_emp_ast_status_val',$status,array('Y' => 'Active Employees', 'B' => 'Blocked Employees'),array('data-label'=>'Employee Status','empty'=>'All Status','onchange'=>'getbranchemployee();'));?>
                    </div>
                </li>
                 <li class="col-sm-2">
                    <div class="material" id='li_asset_employee_id'>    
                        <?php echo CHtml::dropDownList('_asset_employee_id',$employee_id,Employee::getEmployeedetails($branch_id,$status),array('data-label'=>'Employee','empty'=>'All','data-search'=>true));?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_asset_id',$asset_id,HrMasAsset::getAssets(),array('data-label'=>'Asset','empty'=>'All','data-search'=>true));?>
                    </div>
                </li>
                
                <li class="col-sm-2">
                    <div class="material">    
                        <?php echo CHtml::dropDownList('_sort_order_asset',$sort,array(1 =>'Asset', 2 => 'Employee'),array('data-label'=>'Sort By'));?>
                        <?php echo CHtml::HiddenField('distribution_status');?>
                    </div>
                </li>
                <li class="col-sm-2">
                    <button type="button" onclick="loadassetlist();return false;" class='btn btn-theme'>Load</button>
                    <button type="button" onclick="resetfilters();return false;" class='btn btn-warning'>Reset</button>
                    <button type="button" class="btn btn-danger " id="<?php echo rand();?>" data-dismiss="modal">Back</button>
                </li>
             </ul>
        </div>
        <div class="col-md-12">
            <div class="col-lg-6"><div class="title text-center text-bold">ASSET AVAILABILITY</div><div id="chart_asset_master"></div></div>
            <div class="col-lg-6"><div class="title text-center text-bold">ASSET ALLOCATION</div><div id="chart_asset_allocation"></div></div>
            <div class="col-lg-12"><div class="title text-center text-bold">ASSET INVENTORY</div><div id="chart_asset_inventory"></div></div>
        </div>
        <div class="col-md-12">
            <div class="personal_dett clearfix form-ul material" id="div_asset_details">
                <?php
                $chartData_asset_distribution=$chartData_asset_allocation=$chartData_asset_inventory='';
                $condition_11='1=1';
                if($asset_id>0){
                    $condition_11.=' AND asset_id="'.$asset_id.'"';
                }
                $condition_12 = $condition_11.' AND availability_status="N" and asset_status="G"';
                $model_distributed_asset= HrMasAssetDetails::model()->count(array('condition' =>$condition_12));
                $chartData_asset_distribution.='{"asset_status": "Distributed","asset_count": "'.$model_distributed_asset.'","distribute_status": "D"},';
                $condition_13 = $condition_11.' AND availability_status="Y" and asset_status="G"';
                $model_non_distributed_asset= HrMasAssetDetails::model()->count(array('condition' =>$condition_13));
                $chartData_asset_distribution.='{"asset_status": "Non Distributed","asset_count": "'.$model_non_distributed_asset.'","distribute_status": "N"},';
                //Asset Inventory
                $condition='isActive="Y"';
                if($asset_id>0){
                    $condition.=' AND id="'.$asset_id.'"';
                }
                $model_mas_asset= HrMasAsset::model()->findAll(array('condition' =>$condition,'order' => 'id ASC'));
                if(!empty($model_mas_asset)){
                    foreach ($model_mas_asset as $key_3 => $value_3) {
                        $model_distributed_asset= HrMasAssetDetails::model()->count(array('condition' =>'availability_status="N" and asset_status="G" AND asset_id="'.$value_3->id.'"'));
                        $model_non_distributed_asset= HrMasAssetDetails::model()->count(array('condition' =>'availability_status="Y" and asset_status="G" AND asset_id="'.$value_3->id.'"'));
                        $model_repair_asset= HrMasAssetDetails::model()->count(array('condition' =>'(asset_status="D" OR asset_status="R") AND asset_id="'.$value_3->id.'"'));
                        $chartData_asset_inventory.='{"asset_name": "'.strtoupper($value_3->asset_name).'","distributed": "'.$model_distributed_asset.'","stock": "'.$model_non_distributed_asset.'","repair": "'.$model_repair_asset.'"},';
                    }
                ?>
                <div class="table-responsive">
                    <table class="table table-hover table-bordered personal-task" style="font-size:12px;">
                        <tr style="background-color: #005aa6; color: white">   
                            <th style="width: 3%" class="text-center">No</th>
                            <th style="width: 5%" class="text-center">Code</th>
                            <th style="width: 25%" class="text-center">Employee Name</th>
                            <th style="width: 7%" class="text-center">Date of Issue</th>
                            <th style="width: 10%" class="text-center">Reference No</th>
                            <th style="width: 6%" class="text-center">Value</th>
                            <th style="width: 12%" class="text-center">Repair/Extra Payment</th>
                            <th style="width: 7%" class="text-center">Status</th>
                            <th style="width: 25%" class="text-center">Notes</th>
                        </tr>
                    <?php
                    $model_user = User::model()->findByPk(Yii::app()->user->id);
                    $arr_status=array('1' => 'Issued', '2' => 'Returned', '3' => 'Discarded', '4' => 'Lost');
                    $condition_2='1=1';
                    if ($status=='Y') {
                        $condition_2.= ' AND employeedetails.isActive!= "B"';
                    }else if ($status=='B') {
                        $condition_2.= ' AND employeedetails.isActive= "B"';
                    }
                    if ($branch_id>0) {
                        $condition_2.= ' AND employeedetails.branch_or_sponsor_id= "'.$branch_id.'"';
                    }else{
                        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                            $condition_2.= ' and employeedetails.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
                        }
                    }
                    if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
                        $condition_2.= ' and employeedetails.reporting_manager="'.$model_user->department_head_id.'"';
                    }
                    if ($employee_id>0) {
                        $condition_2.= ' AND t.employee_id= "'.$employee_id.'"';
                    }
                    $g=1;
                    foreach ($model_mas_asset as $key_1 => $value_1) {
                        ?>
                        <?php
                        $condition_1 = $condition_2.' AND t.master_asset_id = "'.$value_1->id. '" AND t.asset_status="1"';
                        $model_assets =EmployeeAsset::model()->with('assetdetails','employeedetails')->findAll(array('condition' =>$condition_1,'group'=> 'employee_id'));
                        $model_assets_count =EmployeeAsset::model()->with('assetdetails','employeedetails')->count(array('condition' =>$condition_1));
                        $chartData_asset_allocation.='{"asset_name": "'.strtoupper($value_1->asset_name).'","asset_count": "'.$model_assets_count.'","id": "'.$value_1->id.'"},';
                        $arr_employee = array();
                        foreach ($model_assets as $key => $value) {
                            $arr_employee[$value->employeedetails->employeefullname . ' ' . $value->employeedetails->employeecode] = $value['employee_id'];
                        }
                        ksort($arr_employee); 
                        if(!empty($arr_employee)){
                        ?>
                        <tr><td colspan="9" class="text-left text-bold" style="color: red; font-size: 16px; background-color: #eedbd6"><?php echo strtoupper($value_1->asset_name); ?></td></tr>
                        <?php
                            foreach ($arr_employee as $emp_id) {
                                $model_employee_asset= EmployeeAsset::model()->with('assetdetails')->find(array('condition' =>'employee_id="'.$emp_id.'" and t.master_asset_id = "'.$value_1->id. '" AND t.asset_status="1"'));
                                $asset_date_issue="";
                                if($model_employee_asset->asset_date_issue!='' && $model_employee_asset->asset_date_issue!='0000-00-00'){
                                    $asset_date_issue=date("d/m/Y",strtotime($model_employee_asset->asset_date_issue));
                                }
                                ?>
                                <tr>
                                    <td><?php echo $g; ?></td>
                                    <td><?php echo $model_employee_asset->employeedetails->employeecode; ?></td>
                                    <td><?php echo $model_employee_asset->employeedetails->employeefullname; ?></td>
                                    <td class="text-center"><?php echo $asset_date_issue; ?></td>
                                    <td class="text-right"><?php echo $model_employee_asset->assetdetails->asset_detail; ?></td>
                                    <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model_employee_asset->assetdetails->asset_value,""); ?></td>
                                    <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model_employee_asset->assetdetails->repair_cost_extra,""); ?></td>
                                    <td class="text-center"><?php echo $arr_status[$model_employee_asset->asset_status]; ?></td>
                                    <td><?php echo $model_employee_asset->asset_description; ?></td>
                                </tr>
                                <?php
                                $g++;
                            }
                        }
                    }
                }else{
                    ?>
                            <tr><td colspan="7">No Data Available</td></tr>
                    <?php
                }
                ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="<?php echo rand(); ?>" data-dismiss="modal">Close</button>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getbranchemployee", "function getbranchemployee(){  
    var branch     = $('#_asset_branch_id').val();
    var status     = $('#_emp_ast_status_val').val();
        jQuery.ajax({
           'dataType':'json',
            'data' : {'field':'_asset_employee_id','branch':branch,'status':status},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/hrrepresentation/getbranchemployee') . "',
            'success': function(data) {
                $('#li_asset_employee_id').html(data.employee);
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
   
};", CClientScript::POS_HEAD);
$cs->registerScript("loadassetlist",  "function loadassetlist(){ 
    var branch_id   = $('#_asset_branch_id').val();
    var employee_id   = $('#_asset_employee_id').val();
    var asset_id   = $('#_asset_id').val();
    var status     = $('#_emp_ast_status_val').val();
    var sort_order     = $('#_sort_order_asset').val();
    loadPopupModal('hr/hrrepresentation/assetlist&branch_id='+branch_id+'&employee_id='+employee_id+'&asset_id='+asset_id+'&status='+status+'&sort_order='+sort_order,'Asset List','xl');
};", CClientScript::POS_HEAD);
$cs->registerScript("filterassetdetails",  "function filterassetdetails(){ 
    var branch_id   = $('#_asset_branch_id').val();
    var employee_id   = $('#_asset_employee_id').val();
    var asset_id   = $('#_asset_id').val();
    var status     = $('#_emp_ast_status_val').val();
    var sort_order     = $('#_sort_order_asset').val();
    jQuery.ajax({
        'type':'post',
        'data':'branch_id='+branch_id+'&employee_id='+employee_id+'&asset_id='+asset_id+'&status='+status+'&sort_order='+sort_order,
        'url': '" . Yii::app()->createUrl('hr/hrrepresentation/filterassetdetails') . "',
        'cache': false,
        'success': function(data) {
                $('#div_asset_details').html(data);
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        }
   });
};", CClientScript::POS_HEAD);
$cs->registerScript("filterassetlist",  "function filterassetlist(){ 
    var branch_id   = $('#_asset_branch_id').val();
    var employee_id   = $('#_asset_employee_id').val();
    var asset_id   = $('#_asset_id').val();
    var status     = $('#_emp_ast_status_val').val();
    var sort_order     = $('#_sort_order_asset').val();
    var distribution_status     = $('#distribution_status').val();
    jQuery.ajax({
        'type':'post',
        'data':'branch_id='+branch_id+'&employee_id='+employee_id+'&asset_id='+asset_id+'&status='+status+'&sort_order='+sort_order+'&distribution_status='+distribution_status,
        'url': '" . Yii::app()->createUrl('hr/hrrepresentation/filterassetlist') . "',
        'cache': false,
        'success': function(data) {
                $('#div_asset_details').html(data);
        },
        'beforeSend': function(data) {
            $('#loader').show();
        },
        'complete': function(data) {
            $('#loader').hide();
        }
   });
};", CClientScript::POS_HEAD);
$cs->registerScript("resetfilters", "function resetfilters() {
    $('#_asset_branch_id').multiselect('select', '');
    $('#_asset_branch_id').multiselect('refresh');
    $('#_asset_employee_id').multiselect('select', '');
    $('#_asset_employee_id').multiselect('refresh');
    $('#_asset_id').multiselect('select', '');
    $('#_asset_id').multiselect('refresh');
    $('#_emp_ast_status_val').multiselect('select', 'Y');
    $('#_emp_ast_status_val').multiselect('refresh');
    loadassetlist();
} ", CClientScript::POS_HEAD);
?>
<style>
#chart_asset_inventory {
  width: 100%;
  height: 700px;
}
#chart_asset_master {
  width: 100%;
  height: 400px;
}
#chart_asset_allocation {
  width: 100%;
  height: 400px;
}
</style>
<script>
am4core.ready(function() {
// Themes begin
am4core.useTheme(am4themes_kelly);
// Themes end
am4core.addLicense("ch-custom-attribution");
var chart = am4core.create("chart_asset_master", am4charts.PieChart3D);
chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chart.legend = new am4charts.Legend();
chart.data = [<?php echo $chartData_asset_distribution; ?>];

var series = chart.series.push(new am4charts.PieSeries3D());
series.dataFields.value = "asset_count";
series.dataFields.category = "asset_status";
series.dataFields.distribute_status = "distribute_status";
series.legendSettings.labelText = "{category}: {value.percent.formatNumber('#.0')}%";
chart.legend.valueLabels.template.text = "{value.value}";
series.labels.template.radius = am4core.percent(5);
series.labels.template.fill = am4core.color("black");
series.labels.template.fontSize = 11;
series.labels.template.paddingTop = 0;
series.labels.template.paddingBottom = 0;
series.slices.template.events.on("hit", function(ev){
  var distribution_status=ev.target.dataItem.distribute_status;
  var status_val   = $('#_distribution_status').val();
  if(distribution_status==status_val){
      distribution_status='';
  }
  $('#distribution_status').val(distribution_status);
  var series = ev.target.dataItem.component;
  series.slices.each(function(item) {
    if (item.isActive && item != ev.target) {
      item.isActive = false;
    }
  })
   var status_val   = $('#distribution_status').val();
    if(status_val!=''){
        filterassetlist();
    }else{
        loadassetlist();
    }
});
chart.legend.valueLabels.template.disabled = true;
chart.legend.fontSize= 11;
chart.legend.fontWeight="bold";
chart.legend.maxHeight = 100;
chart.legend.scrollable = true;
chart.legend.itemContainers.template.paddingTop = 2;
chart.legend.itemContainers.template.paddingBottom = 2;
//Allocation
var chart = am4core.create("chart_asset_allocation", am4charts.PieChart3D);
chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
chart.legend = new am4charts.Legend();
chart.data = [<?php echo $chartData_asset_allocation; ?>];

var series = chart.series.push(new am4charts.PieSeries3D());
series.dataFields.value = "asset_count";
series.dataFields.category = "asset_name";
series.dataFields.id = "id";
series.legendSettings.labelText = "{category}: {value.percent.formatNumber('#.0')}%";
chart.legend.valueLabels.template.text = "{value.value}";
series.labels.template.radius = am4core.percent(5);
series.labels.template.fill = am4core.color("black");
series.labels.template.fontSize = 11;
series.labels.template.paddingTop = 0;
series.labels.template.paddingBottom = 0;
series.slices.template.events.on("hit", function(ev){
  var _asset_id=ev.target.dataItem.id;
  var asset_id   = $('#_asset_id').val();
  if(_asset_id==asset_id){
      _asset_id='';
  }
  $('#_asset_id').multiselect('select', _asset_id);
  $('#_asset_id').multiselect('refresh');
  var series = ev.target.dataItem.component;
  series.slices.each(function(item) {
    if (item.isActive && item != ev.target) {
      item.isActive = false;
    }
  })
  filterassetdetails();
});
chart.legend.valueLabels.template.disabled = true;
chart.legend.fontSize= 11;
chart.legend.fontWeight="bold";
chart.legend.maxHeight = 100;
chart.legend.scrollable = true;
chart.legend.itemContainers.template.paddingTop = 2;
chart.legend.itemContainers.template.paddingBottom = 2;
//Asset Inventory
// Create chart instance
var chart = am4core.create("chart_asset_inventory", am4charts.XYChart);


// Add data
chart.data = [<?php echo $chartData_asset_inventory; ?>];

// Create axes
var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
categoryAxis.dataFields.category = "asset_name";
categoryAxis.renderer.grid.template.location = 0;


var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
valueAxis.renderer.inside = true;
valueAxis.renderer.labels.template.disabled = true;
valueAxis.min = 0;

// Create series
function createSeries(field, name,color) {
  
  // Set up series
  var series = chart.series.push(new am4charts.ColumnSeries());
  series.name = name;
  series.dataFields.valueY = field;
  series.dataFields.categoryX = "asset_name";
  series.sequencedInterpolation = true;
  
  // Make it stacked
  series.stacked = true;
  series.columns.template.fill = am4core.color(color);
  // Configure columns
  series.columns.template.width = am4core.percent(60);
  series.columns.template.tooltipText = "[bold]{name}[/]\n[font-size:14px]{categoryX}: {valueY}";
  
  // Add label
  var labelBullet = series.bullets.push(new am4charts.LabelBullet());
  labelBullet.label.text = "{valueY}";
  labelBullet.locationY = 0.5;
  labelBullet.label.hideOversized = true;
  
  var columnTemplate = series.columns.template;
        columnTemplate.strokeWidth = 0;
        columnTemplate.strokeOpacity = 1;
  return series;
}

createSeries("distributed", "Distributed","#21bf0e");
createSeries("stock", "Non Distributed","#66ebfb");
createSeries("repair", "Repair or Maintenance","#FF0000");
// Legend
chart.legend = new am4charts.Legend();
}); // end am4core.ready
</script>