<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        List of Employee Salary Advance
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th class="text-center tbl-iw nw">No</th>
                        <th class="text-center tbl-iw nw">ID</th>                    
                        <th class="text-center tbl-iw nw">Name</th>        
                        <th class="text-center tbl-iw nw">Advance Amount</th>      
                        <th class="text-center tbl-iw nw">Approved Date</th>  
                        <th class="text-center tbl-iw nw">Status</th>
                </thead>
                <tbody>
                    <?php
                    $condition = "1=1";
                    if ($employee_id != '') {
                        $condition .= ' AND employee_id= "' . $employee_id . '"';
                    }
                    if ($branch_id != '') {
                        $condition .= ' AND employeedetail.branch_or_sponsor_id= "' . $branch_id . '"';
                    }
                    if ($status != '') {
                        $condition .= ' AND advance_payment_status = "' . $status . '"';
                    }

                 $model_advance=EmployeeSalaryAdvance::model()->with('employeedetail')->findAll(array('condition' => $condition)); 

                    foreach ($model_advance as $j => $advance_detail) {
                        ?>
                        <tr>
                            <td class="text-center tbl-iw nw"><?php echo $j + 1; ?></td>
                            <td class="text-center tbl-iw nw"><?php echo $this->ciphertext($advance_detail->employeedetail->employee_code, "d"); ?></td>
                            <td class="text-left tbl-iw nw"><?php echo $this->ciphertext($advance_detail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($advance_detail->employeedetail->middle_name, "d") . ' ' . $this->ciphertext($advance_detail->employeedetail->last_name, "d"); ?></td>
                            <td class="text-right tbl-iw nw"><?php echo Yii::app()->numberFormatter->formatCurrency($advance_detail->amount,""); ?></td>  
                            <td class="text-center tbl-iw nw"><?php 
                                $advancedate='';												
                                if($advance_detail->approved_date!= '0000-00-00' && $advance_detail->approved_date!= ''){
                                    $advancedate = date("d/m/Y", strtotime($advance_detail->approved_date));
                                }
                                echo $advancedate;
                            ?></td>  
                            <td class="text-left tbl-iw nw"><?php echo EmployeeSalaryAdvance::getStatus($advance_detail->advance_payment_status); ?></td>                    
                        </tr>
                        <?php } ?>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php echo CHtml::link('PDF', array('hrreports/PrintAdvanceReportPDF', 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'status' => $status), array('title' => 'Print Advance List', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <button type="button" class="btn btn-theme" onclick="exceladvancelist();">Excel</button>			  
            </div>
        </div>
    </div>
</div>
</div><?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("exceladvancelist", "function exceladvancelist(){    
    var branch_id = $('#hr_report_branch_id_advance').val();   
    var employee_id = $('#hr_report_employee_id_advance').val();    
    var status = $('#hrreport_advance_status_id').val();   
    window.open($('#liveSite').val()+'index.php?r=hr/excel/PrintAdvanceExcel&branch_id='+branch_id+'&employee_id='+employee_id+'&status='+status, '_blank');
}", CClientScript::POS_HEAD);
