  <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'question-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    ?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo CHtml::dropDownList('question_for',$model[0]->question_type_id,HrQuestionType::gettype(), array('data-label' => 'Question For<span style="color : red;">*</span>','empty'=>'Select')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="questions_item_table">
        <tr>
            <th>No</th> 
            <th>Question</th>
            <th class="text-center">
                <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRowDoc($('#questions_item_table'));"><i class="fa fa-plus"></i></a></th>
        </tr>
        <?php           
            foreach ($model as $i => $detail):                   
        ?>
        <tr>
            <td><label><?php echo ($i+1); ?></label></td> 
            <td>
                <?php echo $form->hiddenField($detail, "[" . $i . "]id"); ?>
                <?php  echo $form->textArea($detail, "[" . $i . "]question",array('class'=>'tooltipster go', 'placeholder' => 'Question', 'title' => 'Question')); ?>                           
            </td>
            <td class="text-center nw" width="1%">
               <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','id'=>$i,'onclick' => 'removeitemRow($(\'#questions_item_table\'),this,this.id)
                                   ', 'title' => 'Remove this item')); ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>

<div class="modal-footer">

    <button type="button" class="btn btn-danger" id="questions_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" onclick="savequestions()">Save</button>
</div>
<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("savequestions", "function savequestions() {
   jQuery.ajax({
      'dataType':'json',
      'data' : $('#question-form').serialize(),
      'type':'post',
      'url': '" . Yii::app()->createUrl('hr/hrquestion/savequestions') . "',
      'cache': false,
      'success': function(data) {
            if(data.status=='success'){
                t8.success('Saved Successfully!');
                $('#questions_close').click();
                reloadTable('#tbl_question_details');
            }
            else{
                $.each(data, function(key, val) {
                    t8.error(''+val+'');
                });
            }

        },
        'beforeSend':function(){
            $('#loader').show();                                                                
        },
        'complete':function(){
            $('#loader').hide();                                                                
        }
    });
};", CClientScript::POS_HEAD);
$cs->registerScript("addTableRowDoc", "function addTableRowDoc(jQtable) {
    var newrow= jQtable.find('tr:last').clone();
    var lastId = jQtable.find('tr:last td>input').attr('id');
    var thenum = lastId.match(/\d+/g);
    var newId = Number(thenum) + 1;
    var newrow= jQtable.find('tr:last').clone();
    newrow.find('label').html(newId+1);
    newrow.find('.hasDatepicker').removeClass('hasDatepicker');
    newrow.find('.datetimepicker').siblings().remove();
    newrow.find('.datetimepicker').datetimepicker( 'destroy' );
    newrow.find('a,input,textarea,label,checkbox,select,div,.errorMessage').each(function() { 
                    this.id= this.id.replace(/\d+/,newId); 
                   if(!$(this).is(':checkbox'))
                        this.value  = ''; 
                    else
                        $(this).prop('checked', false);
                    (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : '';
    });
    jQtable.append(newrow);
  }", CClientScript::POS_HEAD);
$cs->registerScript("removeitemRow", "function removeitemRow(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var id=$('#HrQuestions_'+arr_fields+'_id').val();
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        var tr  =   $(evt).parent().parent();
        if(isRowEmpty(tr)) {
            if(id!=''){
                jQuery.ajax({
                    'type': 'post',
                    'dataType': 'json',
                    'url': '" . Yii::app()->createUrl('hr/hrquestion/deleteQuestion') . "',
                    'data': {'id':id}  ,
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            $(evt).parents('tr').remove();
                            var i=0;
                            jQtable.find('tr:gt(0)').each(function() {
                                $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                {
                                    old_id   =   $(this).attr('id');
                                    if(old_id!==undefined) {
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                    }
                                    old_name =   $(this).attr('name');
                                    if(old_name!==undefined) {
                                        new_name =   old_name.replace(/\d+/,i);
                                        $(this).attr('name',new_name);
                                    }
                                });
                                $(this).find('td:first label').html(++i);
                            });
                            t8.success('Question Deleted');
                            reloadTable('#tbl_question_details');
                        }else{
                            t8.error('Deletion Not Possible, History Exist');
                        }
                    }
                });
            }else{
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() {
                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        if(old_id!==undefined) {
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                        }
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
            }
        }
    }else {
        alert('Atleast one item needed here');
    }
};", CClientScript::POS_HEAD);
?>










