<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadmasappraisaltype", '$(document).ready(function() {
        var table_id ="#tbl_hr_mas_appraisaltype";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
             "order": [[ 1, "asc" ]],
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrmasappraisaltype/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);                   
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
<script>
    function AddContextMenu(row, datas) { 
        let items = {};
        if (datas[2].edit_button !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/hrmasappraisaltype/create&id=" + datas[3],"Edit" ,"lg");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<script>
    function DeleteType(id){
        var r = confirm('Are you sure to delete this?');
        if (r == true)
        {
            jQuery.ajax({
                'type'  : 'post',
                'datatype' :'json',
                'data'  : 'id=' + id,
                'url'  : $('#liveSite').val() + 'index.php?r=hr/hrmasappraisaltype/DeleteType',
                'cache': false,
                'success':function(data){
                    if (data.status == 'fail'){
                    t8.error('Error while Delete.History Exists');
                    } else {
                    $('#tbl_hr_mas_appraisaltype').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
             Goal
            <div class="pull-right">
                <?php  if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_appraisaltype_add']) ||  Yii::app()->user->authorised_user == 1) {?>
                    <!-- <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/hrmasappraisaltype/create','Add Goal','lg')"><i class="fa fa-plus"></i></button> -->
                    <a class="ad-btn"  onclick="loadPopupModal('hr/hrmasappraisaltype/create','Add Goal','lg')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
                <?php  if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_appraisal_weightage_edit']) ||  Yii::app()->user->authorised_user == 1) {?>
<!--                        <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/hrmasappraisaltype/edit','Edit Weightage','lg')"><i class="fa fa-pencil"></i> Weightage</button>-->
                <?php } ?>
                
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_hr_mas_appraisaltype" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Department</th>
                            <th>Goal Count</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
