<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'template-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_upload_tempalte = HrMasterUpload::model()->findByPK(40);
$upload_template_size = $model_upload_tempalte->max_upload_size * 1024 * 1024;
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php
                echo $form->hiddenField($model, 'id'); 
                echo $form->dropdownlist($model, 'branch_id',MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch','empty'=>'All','data-search'=>true)); ?>
            </li>
            <li class="col-sm-4">                
                <?php echo $form->textField($model, 'document_title', array('data-label' => 'Document Name <span style="color:red;">*</span>')); ?>
            </li>
            <?php if($model_upload_tempalte->isActive =='Y'){ ?>
            <li class="col-sm-4">
                
                <?php
                echo $form->labelEx($model, 'Upload Details (Max 1 MB)');
                $allowedExtensions = array("pdf", "doc", "docx","xlsx","csv","xls");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                        'action' => Yii::app()->createUrl('hr/'.Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/upload_template')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => $upload_template_size,
                        'onStart' => "js:function(){}",
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            $('#HrCompanyTemplates_document_name').val(responseJSON.filename); 
                        }",
                    )
                ));
                ?>   
                <?php echo $form->hiddenField($model, 'document_name'); ?>
            </li>
            <?php } ?>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="template_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/hrcompanytemplate/SaveTemplate');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Details Saved Successfully!");
                 $("#template_close").click();
                reloadTable("#tbl_doc_template_details");
            } else { 
                $.each(data, function(key, val) {
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $(".toast8-error").hide(); 
            $("#template-form .template-save-btn").prop("disabled", true);
            $("#template-form .template-save-btn").addClass("btn_loding").removeClass("btn-theme");
        }',
        'complete'=>'function(data) {
            $("#template-form .template-save-btn").prop("disabled", false);
            $("#template-form .template-save-btn").addClass("btn-theme").removeClass("btn_loding");
            $("#loader").hide();
        }',
    ), array('id' => 'mybtn' . rand(), 'class' => 'template-save-btn btn btn-theme'));
    ?>
<script>
$(document).ready(function(){materializing(".material"); });
</script>

</div>


<?php $this->endWidget(); ?>