<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("deleteRequest", "function deleteRequest(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/hrattendanceexcuse/deleteRequest',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    reloadTable('#tbl_admin_clf_approval_details');
                    t8.success('Request Deleted SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("loaddetails", '
    function filterDataTable(employee_id,status,year,branch_id) {
        var employee_id = $("#excuse_employee_id").val();	
        var branch_id       = $("#excuse_branch_id").val();
        var status       = $("#excuse_status").val();
        var table_id ="#tbl_admin_clf_approval_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrattendanceexcuse/GetIndexList') . '",
                type: "POST",
                "data" : {
                    "employee_id" : employee_id,
                    "status" : status, 
                    "branch_id" : branch_id
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
                        processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	  
        filterDataTable();
        materializing(".material");   
    })
	
	', CClientScript::POS_HEAD);
$cs->registerScript("excusedetails", "function excusedetails(){  
    $('#tbl_admin_clf_approval_details').DataTable().destroy();
    filterDataTable();
   
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[5].approve_excuse !== 0) {
            items.approve = {
                name: "Approve",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/hrattendanceexcuse/approvalbylevels&final_level=" + datas[5].final_leve1 + "&level=" + datas[5].level_no + "&id=" + datas[5].id, "Approve Meeting / Flexi Time Request", "xl");
                }
            };
        }
        if (datas[5].view_excuse !== 0) {
            items.view = {
                name: "View",
                icon: "fa-eye",
                callback: function () {
                    loadPopupModal("hr/hrattendanceexcuse/viewdetails&id=" + datas[5].id, "Meeting / Flexi Time Request", "xl");
                }
            };
        }
        if (datas[5].delete_excuse !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                    deleteRequest(datas[5].id);
                }
            };
        }
        if (datas[5].direct_approve_excuse !== 0) {
            items.adminapprove = {
                name: "Direct Approval",
                icon: "fa-thumbs-up",
                callback: function () {
                    loadPopupModal("hr/hrattendanceexcuse/approvalbylevels&final_level=Y&level=" + datas[5].last_level + "&id=" + datas[5].id, "Approve Meeting / Flexi Time Request", "xl");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<style>
    #employeetimeexcuseindexdropdown .material-select-label {
        display: none;
    }
</style>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
         <!-- <i class="fa fa-suitcase"></i> -->
        Meeting /  Flexi Time Request
        <div class="pull-right dis-flx psn-flxi">
            <div class="material col-sm-12 pd-zero" id="employeetimeexcuseindexdropdown">   

                <span class="col-sm-4 pull-right">  
                    <?php
                    $dropdown_list = array();
                    $model_approval_status = HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select' => 'max(max_level) as max_level', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" and functionality_id="12"'));
                    $max_level = '';
                    if (!empty($model_approval_status)) {
                        $max_level = $model_approval_status->max_level;
                    }
                    $selected = 'H';
                    if ($max_level <= 1) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Approved",
                            3 => "Level 1 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 2) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Approved",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Approved",
                            5 => "Level 2 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 3) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Approved",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Approved",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Approved",
                            7 => "Level 3 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 4) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Approved",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Approved",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Approved",
                            7 => "Level 3 Rejected",
                            8 => "Level 4 Approved",
                            9 => "Level 4 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    } else if ($max_level <= 5) {
                        $dropdown_list = array(
                            1 => "Applied",
                            2 => "Level 1 Approved",
                            3 => "Level 1 Rejected",
                            4 => "Level 2 Approved",
                            5 => "Level 2 Rejected",
                            6 => "Level 3 Approved",
                            7 => "Level 3 Rejected",
                            8 => "Level 4 Approved",
                            9 => "Level 4 Rejected",
                            10 => "Level 5 Approved",
                            11 => "Level 5 Rejected",
                            12 => "Approved",
                            13 => "Rejected"
                        );
                    }
                    $dropdown_list['H'] = 'Waiting For HR Approval';
                    echo CHtml::dropdownlist('excuse_status', $selected, $dropdown_list, array('title' => 'Please select Status', 'data-search' => true, 'multiple' => true, 'onchange' => 'excusedetails();'));
                    ?>
                </span>

                <span class="col-sm-4 pull-right">  
                    <?php echo CHtml::dropDownList("excuse_employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select Employee', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true, 'onchange' => 'excusedetails();')); ?>  
                </span>
            </div>
            <input type="hidden" id="excuse_branch_id" name="excuse_branch_id" value="<?php echo $branch; ?>"/>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_attendance_excuse_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn" data-toggle="modal" onclick="loadPopupModal('hr/hrattendanceexcuse/createexcuse&branch=<?php echo $branch; ?>', 'Add  Meeting / Flexi Time Request', 'xl');">   
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_admin_clf_approval_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Employee Code</th>
                        <th>Employee Name</th>
                        <th>Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
