<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'maseos-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>

<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo $form->hiddenField($model, 'id');?>
                <?php echo $form->textField($model, 'clearance_name',array('data-label'=>'EOS Clearance Name <span style="color:red">*</span>','data-validation'=>'required')); ?>
                <?php echo $form->error($model,'clearance_name'); ?>
            </li>	
				
            <li class="col-sm-6">
                <?php echo $form->dropDownList($model, 'isActive', array('Y' => 'Active', 'N' => 'Deactive'), array('data-label' => 'Status')); ?>					
                <?php echo $form->error($model, 'isActive'); ?>
            </li>
        </ul>
    </div>   
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" data-dismiss="modal" id="mas_eos_close">Close</button>
    <?php 
        $url= Yii::app()->createUrl('/hr/eosdetails/SaveMasEOSClearance');
        echo CHtml::ajaxSubmitButton('Save', $url, array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                if(data.status=="success"){  
                    t8.success("Saved Successfully!");
                    $("#mas_eos_close").click();
                    reloadTable("#tbl_maseos_details");
                } else { 
                    $("#maseos-form .maseos-save-btn").prop("disabled", false);                      
                    $("#maseos-form .maseos-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
                    $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                    }); 
                } 
            }',
            'beforeSend' => 'function(){
                $("#loader").show();
                $("#maseos-form .maseos-save-btn").prop("disabled", true);                      
                $("#maseos-form .maseos-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
                $(".toast8-error").hide(); 
            }',
            'complete' => 'function(){
                $("#loader").hide();
                $("#maseos-form .maseos-save-btn").prop("disabled", false);                      
                $("#maseos-form .maseos-save-btn").addClass("btn-theme").removeClass("btn_loding");  
            }'  
        ), array('id' => 'mybtn' . rand(), 'class' => 'maseos-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>










