<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadticketdetails", '
    function filterDataTable(status) {
        var table_id ="#tbl_familytkt_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            columns: [            
                {className: "" },
                {className: "" },
                {className: ""}, 
                {className: ""}, 
                {className: ""},

            ],
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/employeetickets/GetFamilyTicket') . '",
                type: "POST",
                "data" : {
                    "status" : status,             
                },
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
                        processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	  
        var status  = $("#emp_tkt_status").val();	
        filterDataTable(status);
    })
	
	', CClientScript::POS_HEAD);
$cs->registerScript("ticketflydetails",  "function ticketflydetails(){  
    $('#tbl_familytkt_details').DataTable().destroy();
    var status  = $('#emp_tkt_status').val();
    filterDataTable(status);
   
};", CClientScript::POS_HEAD);
$cs->registerScript("deleteticket",  "function deleteticket(id){
    var r = confirm('Delete Ticket?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'dataType':'json',
              'url'  : $('#liveSite').val()+'index.php?r=hr/employeetickets/deleteticket',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_familytkt_details');
                    t8.success('Deleted');
                }else {
                    t8.error('Error in deleting');
                }

               }

            });

        }
};", CClientScript::POS_HEAD);
?>
<script>
     function AddContextMenu(row, datas) { 
            let items = {};
                items.view = {
                    name: "View",
                    icon: "fa-eye",
                    callback: function () {
                         loadPopupModal("hr/employeetickets/viewfamilyticketdetails&id=" + datas[5].id, 'Family Ticket', "lg");
                }
                };
                items.delete = {
                    name: "Delete",
                    icon: "fa-trash",
                    callback: function () {
                         deleteticket(datas[5].id);
                }
                };
           if (Object.keys(items).length > 0) {
               $(row).contextMenu({
                   selector: 'td',
                   items: items
               });
           }
       }
    
</script>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <!-- <i class="fa fa-fighter-jet"></i>  -->
            Family Ticket
            <div class="pull-right">
                <?php
                echo CHtml::dropdownlist('emp_tkt_status',"",array(1 => 'Applied',2=> 'Approved',3=>'Rejected'),  array('class'=>'col-sm-4 form-control_1','title' => 'Please select Status','empty'=>'All','onchange'=>'ticketflydetails()')); 
                $model_employee = User::model()->findByPk(Yii::app()->user->id);
                $employee_id = $model_employee->employee_id;
                $model_ticket = EmployeeTicket::model()->find(array('condition'=>'employee_id="'.$employee_id.'" and year="'.date('Y').'" and ticket_type="F" and (status="1" OR status="2")'));
                if(empty($model_ticket)){
                ?>
                 <a class="ad-btn" onclick="loadPopupModal('hr/employeetickets/familytkt','Family Ticket','lg')"title='Add'>                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_familytkt_details" style="font-size: 12px">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Applied Date</th>
                            <th>Approved Date</th>
                            <th>Year</th>  
                            <th>Status</th>  
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
