<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'familytkt-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-7">
               <?php
                echo $form->textArea($model,'family_member', array('data-label' => 'Family Members'));
                ?>  
            </li>
            <li class="col-sm-5">
                <?php
                 $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
                echo $form->hiddenField($model,"employee_id",array('value'=>$empid)); ?>
                <?php echo $form->textField($model, 'travel_date',array('class' => 'datepicker','title' => 'Date of Journey','data-label'=>'Date of Journey', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo $form->textField($model, 'travel_destination',array('class' => 'tooltipster','title' => 'Destination','data-label'=>'Destination')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo $form->textField($model, 'return_date',array('class' => 'datepicker','title' => 'Return Date','data-label'=>'Return Date', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-7">
                <?php echo $form->textField($model, 'return_destination',array('class' => 'tooltipster','title' => 'Return Destination','data-label'=>'Return Destination')); ?>
            </li>
        </ul>

    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="ticket_fly_close" data-dismiss="modal">Close</button>
    <button type="button" class="btn btn-theme" onclick="savefamilyticket();">Save</button>
</div>
<?php $this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript('savefamilyticket', 'function savefamilyticket(){	
    jQuery.ajax({
        "dataType":"json",
        "data" : $("#familytkt-form").serialize(),
        "type"  : "post",
        "url": "' . Yii::app()->createUrl('hr/employeetickets/savefamilyticket') . '",
        "success":function(data){
            if(data.status=="success"){  
                t8.success("Details Saved Successfully!");
                $("#ticket_fly_close").click();
                reloadTable("#tbl_familytkt_details");
            } else { 
                $.each(data, function(key, val) {
                    t8.error(""+val+""); 
                }); 
            } 
        },
        "beforeSend":function(){
            var family_member=$("#EmployeeTicket_family_member").val();
            if(family_member==""){
                t8.error("Enter Passengers Name");
                return false;
            }else{
                $("#loader").show();
            }
        },
        "complete":function(){
            $("#loader").hide();
        }
    });
};', CClientScript::POS_HEAD);
?>








