<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'geocode-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>

<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
        <li class="col-sm-6">
                <?php echo CHtml::dropDownList("txt_employee_id", $employee_id, Employee::getEmployees(), array('data-label' => 'Employee', 'prompt' => '--Select--', 'disabled' => 'disabled')); ?>
            </li> 
        </ul>
    </div>
    <hr>
    <div>
        <table class="table table-hover table-bordered personal-task" id="tbl_geocode_details">
            <tr>
                <th>No</th>
                <th>Geocode Location</th>
                <th class="text-center">
                    <a class="btn btn-xs btn-theme " href="javascript:void(0);" onclick="addGeocodeItems($('#tbl_geocode_details'));"><i class="fa fa-plus"></i></a>
                </th>
            </tr>
            <?php foreach ($model_geocode as $i => $document_detail): ?> 
                <tr>
                    <td><label><?php echo ($i + 1); ?></label></td> 
                    <td>
					<?php echo $form->hiddenField($document_detail, "[" . $i . "]id"); ?>
					<?php echo $form->hiddenField($document_detail, "[" . $i . "]employee_id"); ?>
                        <?php echo $form->dropDownList($document_detail, "[" . $i . "]geocode_location_id", HrMasGeocodeLocation::getGeocodelocations(), array('class' => 'form-control searchdropdown', 'data-label' => 'GeoCode Location', 'prompt' => '--Select--', 'data-search' => true)); ?>
                    </td>
                   <td class="text-center nw" width="1%">
                            <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger', 'id' => $i, 'onclick' => 'removeGeoRow($(\'#tbl_geocode_details\'),this,this.id)
                            ', 'title' => 'Remove this item')); ?>
                        </td> 

                </tr>
                <?php endforeach; ?>
        </table>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default" id="geo_close" data-dismiss="modal">Close
    </button>

<?php
$url = Yii::app()->createUrl('hr/employeegeocode/Save');

echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
            t8.success("Saved Successfully!");
            $("#geo_close").click();
            reloadTable("#tbl_emp_geocode_details");
        } else { 
            $("#geocode-form .geocode-save-btn").prop("disabled", false);                      
            $("#geocode-form .geocode-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
            $.each(data, function(key, val) {
                t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
        $("#loader").show();
        $("#geocode-form .geocode-save-btn").prop("disabled", true);                      
        $("#geocode-form .geocode-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
        $(".toast8-error").hide(); 
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'geocode-save-btn btn btn-theme'));
?>
</div>
<?php
$this->endWidget();
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("addGeocodeItems", "function addGeocodeItems(jQtable) {
            var newrow= jQtable.find('tr:last').clone();
            var lastId = jQtable.find('tr:last td>input').attr('id');
            var thenum = lastId.match(/\d+/g);
            var newId = Number(thenum) + 1;
            var newrow= jQtable.find('tr:last').clone();
            newrow.find('label').html(newId+1);
            newrow.find('.hasDatepicker').removeClass('hasDatepicker');
            newrow.find('.datetimepicker').siblings().remove();
            newrow.find('.datetimepicker').datetimepicker( 'destroy' );
            newrow.find('a,input,textarea,label,checkbox,select,div,.errorMessage').each(function() { 
                this.id= this.id.replace(/\d+/,newId); 
                if(!$(this).is(':checkbox'))
                this.value  = ''; 
                else
                $(this).prop('checked', false);
                (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : '';
                });
                jQtable.append(newrow);
                var empid=$('#HrEmployeeGeocode_0_employee_id').val();
                $('#HrEmployeeGeocode_'+newId+'_employee_id').val(empid);
               $('.searchdropdown').multiselect({
                    enableFiltering: true,
                    includeSelectAllOption: true,
                    enableCaseInsensitiveFiltering: true,
                    onDropdownHide: function(event) {
                        $('.btn-select-group').each(function() {
                            if ($(this).attr('id') === '') {
                                $(this).remove(); // Remove empty id divs
                            }
                        });
                },
                onDropdownShown: function(event) {
                    $(document).on('keydown', function(e) {
                        if (e.key === 'Tab') {
                            $(event.target).closest('.btn-select-group').find('.multiselect.dropdown-toggle').dropdown('toggle');
                        }
                    });
                },
                onDropdownHidden: function(event) {
                    $(document).off('keydown');
                }
            });
            $('.btn-select-group').each(function() {
                if ($(this).attr('id') === '') {
                    $(this).remove(); // Remove empty id divs
                }
            });    
         }", CClientScript::POS_HEAD);
        $cs->registerScript("removeGeoRow", "function removeGeoRow(jQtable,evt,field_id) {
            var arr_fields= field_id.split('_');
            var row_field=arr_fields[1];
            var id=$('#HrEmployeeGeocode_'+arr_fields+'_id').val();
            formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
            var num_rows    =   jQtable.find('tr:gt(0)').length;
            if(num_rows>1){
                var tr  =   $(evt).parent().parent();
                if(isRowEmpty(tr)) {
                    if(id!=''){
                        jQuery.ajax({
                            'type': 'post',
                            'dataType': 'json',
                            'url': '" . Yii::app()->createUrl('hr/employeegeocode/deleteGeocode') . "',
                            'data': {'id':id}  ,
                            'cache': false,
                            'success': function(data) {
                                if(data.status=='success'){
                                    $(evt).parents('tr').remove();
                                    var i=0;
                                    jQtable.find('tr:gt(0)').each(function() {
                                        $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                        {
                                            old_id   =   $(this).attr('id');
                                            if(old_id!==undefined) {
                                                new_id   =   old_id.replace(/\d+/,i);
                                                $(this).attr('id',new_id);
                                            }
                                            old_name =   $(this).attr('name');
                                            if(old_name!==undefined) {
                                                new_name =   old_name.replace(/\d+/,i);
                                                $(this).attr('name',new_name);
                                            }
                                            });
                                            $(this).find('td:first label').html(++i);
                                            });
                                            t8.success('Document Deleted');
                                            }else{
                                                t8.error('Deletion Not Possible, History Exist');
                                            }
                                        }
                                        });
                                        }else{
                                            $(evt).parents('tr').remove();
                                            var i=0;
                                            jQtable.find('tr:gt(0)').each(function() {
                                                $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                                {
                                                    old_id   =   $(this).attr('id');
                                                    if(old_id!==undefined) {
                                                        new_id   =   old_id.replace(/\d+/,i);
                                                        $(this).attr('id',new_id);
                                                    }
                                                    old_name =   $(this).attr('name');
                                                    if(old_name!==undefined) {
                                                        new_name =   old_name.replace(/\d+/,i);
                                                        $(this).attr('name',new_name);
                                                    }
                                                    });
                                                    $(this).find('td:first label').html(++i);
                                                    });
                                                }
                                            }
                                            }else {
                                                alert('Atleast one item needed here');
                                            }
                                        };", CClientScript::POS_HEAD);
                                    ?>
 <script type="text/javascript">
    $(document).ready(function () {
        $('.disablecopypaste').bind('copy paste cut', function (e) {
 e.preventDefault(); //disable cut,copy,paste
 });
            materializing(".material");
        $(".searchdropdown").multiselect({
        enableFiltering: true,
        includeSelectAllOption:true,
        enableCaseInsensitiveFiltering: true,
        onDropdownHide: function(event) {
              $(".btn-select-group").each(function() {
                  if ($(this).attr("id") === "") {
                      $(this).remove(); // Remove empty id divs
                  }
});
          },
          onDropdownShown: function(event) {
              $(document).on("keydown", function(e) {
                  if (e.key === "Tab") {
                      $(event.target).closest(".btn-select-group").find(".multiselect.dropdown-toggle").dropdown("toggle");
                  }
              });
          },
          onDropdownHidden: function(event) {
              $(document).off("keydown");
          }
        });
        $(".btn-select-group").each(function() {
            if ($(this).attr("id") === "") {
                $(this).remove(); // Remove empty id divs
            }
        });
    });
</script>