<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable(branch_id,id,desg,dept,status,team,report_id)
    {
        var table_id ="#tbl_employee_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,           
            bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/employeechecker/GetEmployeeList') . '",
                type: "POST",
                "data" : {
                    "id" : id,"desg" : desg,"dept" : dept,"branch_id":branch_id,"status":status,"team":team,"report_id":report_id              
                },
                cache : false,
            },
            columnDefs: [
                       {
                          "targets": [9],"visible": false,
                       },
            ],
            order: [[ 9, "asc" ],[ 3, "asc" ]],
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            
        });
        $(".dataTables_scrollFoot").hide();
    }	
		
    $(document).ready(function() {  	 	
        var branch_id= $("#branch_id_val").val();
        var employee_id= $("#employee_id_val").val();	
        var desg= $("#employee_designation_val").val();	
        var dept= $("#employee_department_id_val").val();
        var team= $("#employee_teamname_val").val();
        var status = $("#active_emp_val").val();
        var report_id = $("#employee_reporting_manager_val").val();
        filterDataTable(branch_id,employee_id,desg,dept,status,team,report_id);
    });', CClientScript::POS_HEAD);
$cs->registerScript("employeedetails",  "function employeedetails(){  
    $('#tbl_employee_details').DataTable().destroy();
    var branch_id= $('#branch_id_val').val();
    var employee_id = $('#employee_id_val').val();
    var desg = $('#employee_designation_val').val();
    var dept = $('#employee_department_id_val').val();
    var team= $('#employee_teamname_val').val();
    var status = $('#active_emp_val').val();
    var report_id = $('#employee_reporting_manager_val').val();
    filterDataTable(branch_id,employee_id,desg,dept,status,team,report_id); 
};", CClientScript::POS_HEAD);
$cs->registerScript("BlockEmployee",  "function BlockEmployee(id){

    var r = confirm('Are you sure to Block this Employee?');

        if(r==true)

        {

            jQuery.ajax({

              'type'  : 'post',

              'data'  : 'id=' + id,

              'url'  : $('#liveSite').val()+'index.php?r=hr/employeechecker/Block',

              'cache': false,

              'success':function(data){

                if(data=='fail'){

                    t8.error('This Employee cant be Blocked');

                }else {
                    reloadTable('#tbl_employee_details');
                    t8.success('Employee Blocked SuccessFully!');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
$cs->registerScript("UnBlockEmployee",  "function UnBlockEmployee(id){
    var r = confirm('Are you sure to UnBlock this Employee?');
        if(r==true)

        {

            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/employeechecker/UnBlock',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('This Employee cant be UnBlocked');
                }else {
                    reloadTable('#tbl_employee_details');
                    t8.success('Employee UnBlocked SuccessFully!');

                }

               }

            });

        }
};", CClientScript::POS_HEAD);
$cs->registerScript("resetpassword",  "function resetpassword(id){
    var r = confirm('Confirm password reset?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'dataType':'json',
              'url'  : $('#liveSite').val()+'index.php?r=hr/passwordchange/resetemployeepassword',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    t8.success('Password Changed and notification sent');
                }else {
                    t8.error('Error in resetting password');
                }

               }

            });

        }
};", CClientScript::POS_HEAD);
$cs->registerScript("getbranchemployees", "function getbranchemployees(){  
     var branch_id= $('#branch_id_val').val();
        jQuery.ajax({
           'dataType':'json',
            'data' : {'branch_id':branch_id},
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/employeechecker/employeebybranch') . "',
            'success': function(data) {
                $('#employee_id_val').html(data.employee);
            },
            'beforeSend':function(){
                $('#loader').show();
            },
            'complete':function(){
                $('#loader').hide();
            }
        });
   
};", CClientScript::POS_HEAD);
?>
    <section class="panel" style="background-color:#F6F3EE; font-size: 10px;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-users"></i> Employees <a href="/latesthr/index.php?r=hr/checker/index"><button class="btn btn-sm btn-theme"><i class="fa fa-plus"></i> Checker</button></a>
            <div class="pull-right">
                <?php echo CHtml::dropdownlist('active_emp_val','',array('Y'=>'Current','N'=>'Old'),  array('empty' => 'All Employees','class'=>'col-sm-2 form-control_1','title' => 'Employee Status','onchange'=>'employeedetails();','data-search'=>true)); ?>                   
                <?php echo CHtml::dropdownlist('branch_id_val','',MasCompanyBranchSponsor::getCompanyBranches(),  array('empty' => 'All Branches','class'=>'col-sm-3 form-control_1','title' => 'Please Select Branch','onchange'=>'getbranchemployees(); employeedetails();','data-search'=>true)); ?>                   
                <?php echo CHtml::dropdownlist('employee_id_val','',Employee::getEmployee(),  array('empty' => 'All Employees','class'=>'col-sm-3 form-control_1','title' => 'Please Select Employee','onchange'=>'employeedetails();','data-search'=>true,'style'=>'width:150px;')); ?>                   
               <?php echo CHtml::dropdownlist('employee_teamname_val','',HrMasTeamName::getteam(),  array('empty' => 'All Team','class'=>'col-sm-2 form-control_1','title' => 'Please Select Team','onchange'=>'employeedetails();','data-search'=>true,'style'=>'width:150px;')); ?>   
                <?php echo CHtml::dropdownlist('employee_department_id_val','',MasDepartment::getDepartment(),  array('empty' => 'All Departments','class'=>'col-sm-2 form-control_1','title' => 'Please Select Department','onchange'=>'employeedetails();','data-search'=>true,'style'=>'width:150px;')); ?>                   
                <?php echo CHtml::dropdownlist('employee_designation_val','',MasDesignation::getDesignation(),  array('empty' => 'All Designations','class'=>'col-sm-2 form-control_1','title' => 'Please Select Designation','onchange'=>'employeedetails();','data-search'=>true,'style'=>'width:150px;')); ?>
                 <?php echo CHtml::dropdownlist('employee_reporting_manager_val','',ReportingManager::getReportingManager(),  array('empty' => 'Reporting Managers','class'=>'col-sm-2 form-control_1','title' => 'Please Select Reporting Manager','onchange'=>'employeedetails();','data-search'=>true,'style'=>'width:120px;')); ?>
                <?php 
                $model_mas_company=MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
                $total_employee_count = Employee::model()->count();
                if($total_employee_count<=$model_mas_company->total_employees_allowed){
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_add'])  || Yii::app()->user->authorised_user == 1) { ?>
                        <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/employeechecker/create','Add New Employee','xl')"><i class="fa fa-plus"></i></button>  &nbsp;
                    <?php }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_upload'])  || Yii::app()->user->authorised_user == 1) { ?>
                        <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/employeechecker/uploademployee','Upload Employees','lg')" title="Upload Basic Details"><i class="fa fa-user"></i> <i class="fa fa-upload"></i></button>  
                    <?php } 
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_salary_upload'])  || Yii::app()->user->authorised_user == 1) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/employeechecker/uploadsalary','Upload Salary','lg')" title="Upload Initial Salary Details"><i class="fa fa-money"></i> <i class="fa fa-upload"></i></button>  
                <?php } 
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_documents_upload'])  || Yii::app()->user->authorised_user == 1) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/employeechecker/uploademployeedocuments','Upload Documents','lg')" title="Upload Documents Details"><i class="fa fa-book"></i> <i class="fa fa-upload"></i></button>  
                <?php } 
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_leave_upload'])  || Yii::app()->user->authorised_user == 1) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/employeechecker/uploademployeeleave','Upload Leave Details','lg')" title="Upload Leave Details"><i class="fa fa-sign-out"></i> <i class="fa fa-upload"></i></button>  
                <?php }
                ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_employee_details" style="font-size:12px;width: 100%;">
                    <thead>
                        <tr>
                            <th>No</th>
                            
                            <th>Code</th>
                            <th>Employee Name</th>
                            <!--<th>Team</th>-->
                            <th>IBAN</th>  
                            <th>ROUTING CODE</th>  
                            <th>WPS Company</th>
                            <th>RM</th>
                            <th>Actions</th>
                            <th></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
